#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>
#endregion

using EnterpriseDT.Net.Ftp;
using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace Xbgm.Core
{
	public delegate void Notifier(string[] rootspace);
	public delegate void Logger(string msg);
	public delegate void UpdateStatus(bool online);
	
	public class FtpToXbox
	{	
		// Event send to the Main GUI
		public event EventHandler EventUpdated;
		public event Notifier notifyViews;
		public event Logger loggerViews;
		public event UpdateStatus StatusViews;
		public Action action = Action.ready;
		public Dashboards dashboard = Dashboards.unknown;
		public Parser.Summary gameSummary;
		public string[] Rootspace;
		public string Msg;
		public string MsgError;
		public bool In_Thread;
		public bool Online;
		public bool Done;
		public int Index = -1;
		#if (GUI)
		public SaveInfo[] MySaveInfo;
		#endif
		
		public Xbgm.Config 			config;
		private Xbgm.Core.Messages 	msg;
		private Xbgm.Core.Parser 	parser;
		private Xbgm.Core.FtpLogger logger;
		
		private FTPClient ftp;
				
		// Constructor
		public FtpToXbox(ref Xbgm.Config config, Messages msg)
		{
			this.config = config;
			this.msg = msg;
			this.MsgError = null;
			this.Rootspace = null;
			this.parser = new Parser();
			this.logger = new FtpLogger();
			this.In_Thread = false;
			this.Online = false;
			this.Done = false;
			this.ftp = null;
		}
		 
		public enum Action
			{
				ready, scan, rename, delete, launch, reboot, shutdown,
				xbmc, image, freespace,	allfreespace, format, refresh, 
				error, connect, scanbackup, getbackup
			};
		
		public enum Dashboards
			{
				avalaunch, xbmc, unleachx, unknown
			};		
		
		public bool InThread{
			get { return In_Thread; }
			set { In_Thread = value;}
		}
		
		public void ChangeLabelResults(string[] rootspace)
		{
			#if ( DEBUG )
				Console.WriteLine("In FtpToXbox::ChangeLabelResults\n");
			#endif
			if (In_Thread == false)
				notifyViews(rootspace);
			else {
				Rootspace = rootspace;
				if(this.EventUpdated != null)
					this.EventUpdated(null, null); 
			}
		}
		
		public void UpdateStatus(bool online)
		{
			#if ( DEBUG )
				Console.WriteLine("In FtpToXbox::UpdateStatus\n");
			#endif
			if (In_Thread == false)
				StatusViews(online);
			else {
				Online = online;
				if(this.EventUpdated != null)
					this.EventUpdated(null, null); 
			}
		}
		
		public void Log()
		{
			#if ( DEBUG )
				Console.WriteLine("In FtpToXbox::Log\n");
			#endif
			if (In_Thread == false)
				loggerViews(logger.logIt());
			else {
				Msg = logger.logIt();
				if(this.EventUpdated != null)
					this.EventUpdated(null, null); 
			}
			logger.Flush();
			logger.Close();
		}	
		
		private void Connect()
		{
			try
			{
				// Init the the write memory stream for ftp log
				logger.Init();
				// Update status bar to connecting...
				this.action = Action.connect;
				if(InThread & this.EventUpdated != null) // Tell main windows to wake up
					this.EventUpdated(null, null);
				
				Index = config.GetIndexActive();
				// Create socket
				#if ( DEBUG ) // Forcing logging to console in debug mod
				ftp = new FTPClient(config.xboxs[Index].ip, config.xboxs[Index].port);
				ftp.DebugResponses(true);
				#else
				if (config.ftpverbose) {
					ftp = new FTPClient(config.xboxs[Index].ip, config.xboxs[Index].port, logger.logWriter, 0);
					ftp.DebugResponses(true);
				}
				else
					ftp = new FTPClient(config.xboxs[Index].ip, config.xboxs[Index].port);					
				#endif
				
				ftp.Login(config.xboxs[Index].username, config.xboxs[Index].password);
				ftp.System();

				UpdateStatus(true);			
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::Connect): " + ex.Message);
				#endif
				if (In_Thread) { // in thread mode
					MsgError = ex.Message;
					// Set To error mode
					this.action = Action.error;
					// To refresh the statusbar and stop thread;
					if(this.EventUpdated != null)
						this.EventUpdated(null, null); 
				} else {
					this.action = Action.ready;
					// Make sure methods get to know it.
					throw new Exception("Can't connect to Xbox:\n" + ex.Message);
				}
			} 
		}
		
		private void Disconnect()
		{
			// The default quit wait for a reply but there is none
			// so it crash, need to catch exception
			// or do it like this, I made my own Quit with out reply	
			try
			{
				ftp.QuitXbox();
				UpdateStatus(false);
				Log();
				this.action = Action.ready;
				ftp = null;
			}
			catch (FTPException ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::Disconnect): " + ex.Message);
				#endif
				if (In_Thread) { // in thread mode
					MsgError = ex.Message;
					// Set To error mode
					this.action = Action.error;
					// To refresh the statusbar and stop thread;
					if(this.EventUpdated != null)
						this.EventUpdated(null, null); 
				} else {
					this.action = Action.ready;
					// Make sure methods get to know it.
					throw new Exception("Error Disconnecting:\n" + ex.Message);
				}
			}
			System.GC.Collect();
		}
		

		public bool DeleteGame(ArrayList game, bool deleteSaveGames)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}

			try 
			{
				ftp.TransferType = FTPTransferType.BINARY;
				
				// I don't know why but they do it
				ftp.Site("FREEROOTSPACEDISABLE ");			
				
											// xbe full path
				bool ok = ftp.Site("DELTREE " + game[2]);			
				if(ok == false)
				{
					// then we do it the old way
					ftp.Rmdir(game[2].ToString());
				}
				
				if(deleteSaveGames)
				{										//ID
					ok = ftp.Site(@"DELTREE /E:/UDATA/" + game[3]);
					ok = ftp.Site(@"DELTREE /E:/TDATA/" + game[3]);
				}
			}
			catch (FTPException ex)
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				this.action = Action.ready;
			}
			
			Disconnect();
			
			return true;
		}
		
		public bool DeleteSaveGame(string savegame, string saveprofil, bool profil)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}

			try 
			{
				ftp.TransferType = FTPTransferType.BINARY;
				if (!profil) {
					bool ok = ftp.Site(@"DELTREE /E:/UDATA/" + savegame);
					if (ok)
						ftp.Site(@"DELTREE /E:/TDATA/" + savegame);
					else {
						ftp.Rmdir(@"/E:/UDATA/" + savegame);
						ftp.Rmdir(@"/E:/TDATA/" + savegame);
					}
				} else {
					bool ok = ftp.Site(@"DELTREE /E:/UDATA/" + savegame + "/" + saveprofil);
					if (ok)
						ftp.Site(@"DELTREE /E:/TDATA/" + savegame + "/" + saveprofil);
					else {
						ftp.Rmdir(@"/E:/UDATA/" + savegame + "/" + saveprofil);
						ftp.Rmdir(@"/E:/TDATA/" + savegame + "/" + saveprofil);
					}
				}
			}
			catch (FTPException ex)
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				this.action = Action.ready;
			}
			
			Disconnect();
			
			return true;
		}

		public bool RenameGame(ArrayList game, string newGameName)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}
			ftp.TransferType = FTPTransferType.BINARY;
			ftp.Site("XBERENAME \"" + game[2] + game[1] + "\" " + newGameName);			
			Disconnect();
			return true;
		}
		
		public bool LaunchGame(ArrayList game)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}
			ftp.TransferType = FTPTransferType.BINARY;
			ftp.Site("LAUNCH " + game[2] + game[1]);			
			Disconnect();
			return true;
		}

		public bool LaunchGame(string game)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}
			ftp.TransferType = FTPTransferType.BINARY;
			if (ftp.Site("LAUNCH " + game)) { } // Avalauch & UnleachX
			else { ftp.Site("RunXBE " + game); } // XMBC
			Disconnect();
			return true;
		}

		public void FormatDrive(string drive)
		{
			Connect();
			#if ( DEBUG )
				Console.WriteLine("Format drive " + drive);
			#endif
			// DriveSelected string
			ftp.Site("FORMAT " + drive);

			Disconnect();
		}
		
		public void ActionNotOnGame(Action xboxAction)
		{
			try
			{
				In_Thread = false;
				Connect();
	
				
				this.action = xboxAction;
				
				switch(this.action) 
				{
					case Action.shutdown: // Shutdown
					{
						ftp.Site("SHUTDOWN");
						break;
					}
	
					case Action.reboot: // Restart
					{
						ftp.Site("REBOOT");
						break;
					}
	
					case Action.xbmc: // Launch XBMC
					{
						ftp.TransferType = FTPTransferType.BINARY;
						if (this.dashboard == Dashboards.avalaunch || 
						   this.dashboard == Dashboards.unleachx)
							ftp.Site("LAUNCH " + config.xboxs[Index].xbmc);	// XBMC xbe full path
						else if (this.dashboard == Dashboards.xbmc) 
						{
							if (System.IO.Path.GetExtension(config.xboxs[Index].xbmc).Equals(".xbe"))
								ftp.Site("RunXBE " + config.xboxs[Index].xbmc);
							else
								ftp.Site("RunScript " + config.xboxs[Index].xbmc);
						}
						break;
					}
						
					case Action.refresh: // Refresh Avalaunch menu
					{
						ftp.TransferType = FTPTransferType.BINARY;
		
						// Refresh Avalaunch menu
						ftp.Site("REFRESH");			
						break;
					}
						
					default:            
	           			Console.WriteLine("Invalid Action, has to be shutdown, reboot , refresh or xbmc.");            
	           			break;  
	
				}
				Disconnect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::ActionNotOnGame): " + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw ex;
			}		
		}

		public string GetTitlesCached()
		{
			string freespace = "N/A";
			string[] dir = config.GetDirectoryActive();
			parser.dir = dir[0];
			this.gameSummary = parser.TitlesCached();
			this.action = Action.ready;
			
			return freespace;			
		} // End of GetTitlesCached
		
		public string GetTitles(bool getIcons)
		{
			string freespace = "N/A";
			
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::GetTitles):" + ex.Message);
				#endif
				Disconnect();
				throw new Exception(ex.Message);
			}
			
			this.action = Action.scan;
			if(InThread & this.EventUpdated != null) // Tell main windows to wake up
				this.EventUpdated(null, null);
			ftp.TransferType = FTPTransferType.BINARY;
			// Do all command and get titles game in a string[]
			// The problem of this is than i need to wait to recevied the all list of Game
			string[] dir = config.GetDirectoryActive();	
			for (int i = 0; i < dir.Length; i++) {
			try
			{
				#if (DEBUG)
				Console.WriteLine("gamedir: [" + dir[i] + "]");
				#endif
				//string onedir =  dir[0];
				parser.dir = dir[i];
				//Console.ReadLine();
				if (i == 0)
					gameSummary = parser.Titles(ftp.GetTitles(dir[i]), true);
				else {
					this.action = Action.scan; // We are doing it again for an another directory
					if(InThread & this.EventUpdated != null) // Tell main windows to wake up
						this.EventUpdated(null, null);
					gameSummary = parser.Titles(ftp.GetTitles(dir[i]), false);
				}

				//gameSummary = parser.Titles(ftp.GetTitles(cfg.getFtpInfo().getDirectory()));
				//Console.ReadLine();
				// Check if i need to DL icons
				if (getIcons)
				{
					this.action = Action.image;
					if(InThread & this.EventUpdated != null) // Tell main windows to wake up
						this.EventUpdated(null, null); 
					ftp.Site("TITLEIMAGES");
					ftp.Get(@"titleimage.zip", @"/Z:/titleimage.zip");
					Zip.Extract(@"titleimage.zip", @"titleimage", false);
				}
			
			/* Unused LabelFreeAllResult has been supress
			 * 	this.action = Action.freespace;
				if(InThread & this.EventUpdated != null) // Tell main windows to wake up
					this.EventUpdated(null, null);
				// List free space Game Drive
				ftp.Site("FREEROOTSPACEENABLE");
				string[] rootspace = ftp.Dir("/", true);
				foreach(string space in rootspace)
				{
					//Console.WriteLine("Space:" + space + "]");
					string[] free = space.Split(' ');
					Console.WriteLine("[" + free[24].ToString() +"] == [" + dir[i].Substring(0, 2) +"]");
					if(free[24].Equals(dir[i].Substring(0, 2)))
					{
						#if (DEBUG)
							Console.WriteLine("Free Space:" + free[26].ToString());
						#endif
						freespace = free[26].ToString() + " MB";
					}
				}
				if (i != 0) { freespace = "N/A"; } // Multiple directory can't know how many space
				rootspace = null;
				*/
				}
				catch (Exception ex)
				{
					#if (DEBUG)
						Console.WriteLine("Caught exception (in FtpToXbox::GetTitles):" + ex.Message);
					#endif
					this.action = Action.error;
					MsgError = "No Game in directory " + dir[i];
					if(InThread & this.EventUpdated != null) // Tell main windows to wake up
						this.EventUpdated(null, null);
					Disconnect();
					throw new Exception(ex.Message +  "\nNo Game in directory " + dir[i]);
				}
			}// End for each directoy in config
			
			this.action = Action.allfreespace;
			// List free space for all Drive
			if (ftp.Site("FREEROOTSPACEENABLE") == true)
			{
				string[] rootspace = ftp.Dir("/", true);
				// Updating Views
				this.ChangeLabelResults(rootspace);
				rootspace = null;
				ftp.Site("FREEROOTSPACEDISABLE");
			}
			
			Disconnect();
			if(InThread & this.EventUpdated != null) // Tell main windows to wake up
					this.EventUpdated(null, null);
			return freespace;
		} // End of GetTitles
		
		public bool GetFreeSpace(string xboxDir, UInt32 size)
		{
			bool freespace = false;
			
			Connect();
			
			ftp.TransferType = FTPTransferType.BINARY;

			if (ftp.Site("FREEROOTSPACEENABLE") == true)
			{
				string[] rootspace = ftp.Dir("/", true);
				foreach(string space in rootspace)
				{
					//Console.WriteLine("Space:" + space + "]");
					string[] free = space.Split(' ');
					//Console.WriteLine("[" + free[24].ToString() +"] == [" + Entryxboxdir.Text.Substring(0, 2) +"]");
					if(free[24].Equals(xboxDir))
					{
						//Console.WriteLine("we need:" + fspace[0] + " and we have:" + free[26]);
						if (size > Convert.ToUInt32(free[26]))
							msg.Info("You don't enough free space on " + xboxDir);
						else
							freespace = true;
					}
					free = null;
				}
				rootspace = null;
				ftp.Site("FREEROOTSPACEDISABLE");	
			}
			else
			{ // Not using Avalaunch
				#if ( DEBUG )
					Console.WriteLine("Not using Avalaunch");
				#endif
				freespace = true;		
			}
			
			Disconnect();
			return freespace;
		}

		public bool CheckIfAvalaunch()
		{
			try
			{
				Connect();
				if (ftp.Site("FREEROOTSPACEENABLE") == false) // Check for avalaunch
				{
					Console.WriteLine("This feature requires Avalaunch, or a newer version.");
					MsgError = "This feature requires Avalaunch";
					Disconnect();
					return false;
				}
				Disconnect();
				return true;
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::CheckIfAvalaunch):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}

		public bool CheckDashboard()
		{
			try
			{
				Connect();
				string dash = ftp.System();
				if (dash.StartsWith("UNIX emulation by Avalaunch")) {
					this.dashboard = Dashboards.avalaunch;
					Msg = "Dashboard: Avalaunch";
					if (ftp.Site("FREEROOTSPACEENABLE") == true)
					{
						string[] rootspace = ftp.Dir("/", true);
						// Updating Views
						this.ChangeLabelResults(rootspace);
						rootspace = null;
						ftp.Site("FREEROOTSPACEDISABLE");
					}
				}
				else if(dash.StartsWith("UNIX emulated by FileZilla") || 
				       dash.StartsWith("UNIX emulated by XBMC")) {
					this.dashboard = Dashboards.xbmc;
					Msg = "Dashboard: XBMC";
					GetAllfreeSpace();
				}
				else if((dash.StartsWith("UNIX emulated by UnleashX")) &&
				        (dash.EndsWith("0.36.0620A"))) {
					this.dashboard = Dashboards.unleachx;
					Msg = "Dashboard: Old UnleashX";
					MsgError = "Your UnleashX version is too old.\nPlease Upgrade it";
				}
				else if(dash.StartsWith("UNIX emulated by UnleashX")) {
					this.dashboard = Dashboards.unleachx;
					Msg = "Dashboard: UnleashX";
					GetAllfreeSpace();
				}
				else {
					this.dashboard = Dashboards.unknown;
					Msg = "Dashboard: Unknown";
				}
				Disconnect();
				if (this.dashboard == Dashboards.avalaunch)
					return true;
				else if (this.dashboard == Dashboards.unknown) {
					MsgError = "This feature requires Avalaunch\nYour dashboard cannot be detected.";
					return false;
				} else {
					MsgError = "This feature requires Avalaunch\nYour " + Msg + ".";
					return false;
				}
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::CheckDashboard):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		public void GetAllfreeSpace()
		{
			try
			{
				#if (DEBUG)
					Console.WriteLine("in FtpToXbox::GetAllfreeSpace");
				#endif
				if (this.dashboard == Dashboards.xbmc) {
					string reply = ftp.DirFreespace("/");
					if (reply == null) { return; }
					string[] myreply = reply.Split(' ');
					ArrayList rootspace = new ArrayList();
					/* DEBUG int i = 0;
					foreach (string word in myreply) {
						Console.WriteLine("word:{0} => i {1}", word, i);
						i++;					
					} */
					rootspace.Add(myreply[4]+ " " + myreply[5].Substring(0, myreply[5].Length-1)); // C drive
					rootspace.Add(myreply[7]+ " " + myreply[8].Substring(0, myreply[8].Length-1)); // E drive
					rootspace.Add(myreply[10]+ " " + myreply[11].Substring(0, myreply[11].Length-1)); // F drive
					rootspace.Add(myreply[13]+ " " + myreply[14].Substring(0, myreply[14].Length-1)); // G drive
					// empty array is default
					if (rootspace.Count > 0)
						Rootspace = (string[]) rootspace.ToArray(typeof(string));
				}
				else if (this.dashboard == Dashboards.unleachx) {
					ArrayList rootspace = new ArrayList();
					rootspace.Add(ftp.SiteFreespace("C"));	
					rootspace.Add(ftp.SiteFreespace("E"));
					rootspace.Add(ftp.SiteFreespace("F"));
					if (config.xboxs[Index].Gdrive == true)
						rootspace.Add(ftp.SiteFreespace("G"));
					// empty array is default
					if (rootspace.Count > 0)
						Rootspace = (string[]) rootspace.ToArray(typeof(string));
				}
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::GetAllfreeSpace):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		#if (GUI)
		public void GetListSaveGame()
		{
			try
			{
				Connect();
				this.action = Action.scanbackup;
				ftp.Chdir(@"/E:/UDATA/");
				//ftp.Chdir(@"/home/webadm/test/UDATA/");
				FTPFile[] list = ftp.DirDetails(@"");
				SaveInfo[] temp2 = new SaveInfo[list.Length];
				int count = 0;
				if (!System.IO.Directory.Exists(@"temp"))
					System.IO.Directory.CreateDirectory(@"temp");
				Directory.SetCurrentDirectory(@"temp");
				// For Each Directory saved "Name" And "UDATA Game Directory"
				for (int i = 0; i < list.Length; i++)
				{
					if (list[i].Dir && !list[i].Name.Equals(".."))
					{
						if(InThread & this.EventUpdated != null) // Tell main windows to wake up
							this.EventUpdated(null, null);
						ArrayList savelist = null;
						string Game = null;
						try {
							ftp.Get(@"TitleMeta.xbx", "/E:/UDATA/" + list[i].Name + "/TitleMeta.xbx");
							//ftp.Get(@"TitleMeta.xbx", "/home/webadm/test/UDATA/" + list[i].Name + "/TitleMeta.xbx");
							string line = null;
							StreamReader sr = new StreamReader(@"TitleMeta.xbx");
			                // Read and display lines from the file until the end of 
			                // the file is reached.
			                try { // Only First Line
				                while ((line = sr.ReadLine()) != null)
				                {
				                	if (line.StartsWith("TitleName"))
				                		Game = line.Substring(line.LastIndexOf('=')+1);
									//Console.WriteLine(line);
								}
			                }
			                catch (Exception ex)
			                {
								#if (DEBUG)
									Console.WriteLine("Exception (in FtpToXbox::GetListSaveGame1):" + ex.Message);
								#endif
							}

			                if (Game != null || Game.Length != 0) {
								savelist = GetListSaveProfil(list[i].Name);
								for (int j = 0; j < savelist.Count; j= j +2){
									string ProfilId = savelist[j].ToString();
									string ProfilName = savelist[j+1].ToString();
									Console.WriteLine("Profil_Id: [" + ProfilId + "]\tProfil_Name: ["+ ProfilName +"]");
								}
			                }
			                else
			                {
			                	savelist = null; // if No TitleMeta.xbx then No SaveMeta.xbx
			                	Game = list[i].Name;
			                }
							Console.WriteLine("Dir: ["+ list[i].Name +"] \t Game : ["+ Game +"]");
							//Console.ReadLine();
							sr.Close();
							sr = null;
							line = null;
						}
						catch (Exception ex)
						{   // If no TitleMeta.xbx file
							if (list[i].Name.Equals("0facfac0"))
								Game = "DVD2XBOX";
							else if (list[i].Name.Equals("53530003"))
								Game = "Outlaw Volleyball";
							else
								Game = list[i].Name + " No TitleMeta.xbx";
							savelist = null; // if No TitleMeta.xbx then No SaveMeta.xbx
							Console.WriteLine("{In Exception} Dir: ["+ list[i].Name +"] \t Game : ["+ Game +"]");
							#if (DEBUG)
								Console.WriteLine("Exception (in FtpToXbox::GetListSaveGame2):" + ex.Message);
							#endif
						}
						SaveInfo save = new SaveInfo(Game, list[i].Name, savelist);		
						if (save != null)
						{
							temp2[count++] = save;
						}
						savelist = null;
						Game = null;
					}
				}
				MySaveInfo = new SaveInfo[count];
				Array.Copy(temp2, 0, MySaveInfo, 0, count);
				File.Delete(@"TitleMeta.xbx");
				Directory.SetCurrentDirectory(@"..");
				list = null;
				temp2 = null;
				Disconnect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::GetListSaveGame3):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		public ArrayList GetListSaveProfil(string namedir)
		{
			try
			{
				ftp.Chdir(namedir);
				FTPFile[] list = ftp.DirDetails(@"");
				ArrayList savelist = new ArrayList();
				for (int i = 0; i < list.Length; i++)
				{
					if (list[i].Dir && !list[i].Name.Equals(".."))
					{
						try {
							ftp.Get(@"SaveMeta.xbx", "/E:/UDATA/" + namedir + "/" + list[i].Name + "/SaveMeta.xbx");
							//ftp.Get(@"SaveMeta.xbx", "/home/webadm/test/UDATA/" + namedir + "/" + list[i].Name + "/SaveMeta.xbx");
							string line = null;
							string Profil = null;
							StreamReader sr = new StreamReader(@"SaveMeta.xbx");
			                // Read and display lines from the file until the end of the file is reached.
			                try { // Only First Line
				                if ((line = sr.ReadLine()) != null)
				                {
				                	Profil = line.Substring(line.LastIndexOf('=')+1);
									//Console.WriteLine(line);
								}
			                }
			                catch (Exception ex)
			                {
								#if (DEBUG)
									Console.WriteLine("Exception (in FtpToXbox::GetListSaveProfil1):" + ex.Message);
								#endif
							}		                
							//Console.WriteLine("Dir: [" + list[i].Name + "]\tProfil: ["+ Profil +"]");
							savelist.Add(list[i].Name);
							savelist.Add(Profil);
							sr.Close();
							sr = null;
							line = Profil = null;
						}
						catch (Exception ex)
						{
							//Console.WriteLine("Dir: [" + list[i].Name + "]\tProfil: ["+ Profil +"]");
							#if (DEBUG)
								Console.WriteLine("Exception (in FtpToXbox::GetListSaveProfil2):" + ex.Message);
							#endif
						}
						File.Delete(@"SaveMeta.xbx");
					}
				}
				ftp.Chdir(@"..");
				list = null;
				return savelist;
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::GetListSaveProfil3):" + ex.Message);
				#endif
				throw new Exception(ex.Message);
			}
		}
		
		public void BackupAllSaveGame(SaveInfo[] MySaveInfo)
		{
			try
			{
				Connect();
				ftp.TransferType = FTPTransferType.BINARY;
				this.action = Action.getbackup;
				ftp.Chdir(@"/E:/UDATA/");
				//ftp.Chdir(@"/home/webadm/test/UDATA/");
				if (!System.IO.Directory.Exists(@"saves"))
					System.IO.Directory.CreateDirectory(@"saves");
				Directory.SetCurrentDirectory(@"saves");
				ZipCompress zip = new ZipCompress();
				for (int i = 0; i < MySaveInfo.Length; i++)
				{
					Console.WriteLine(MySaveInfo[i].Id + "\t" + MySaveInfo[i].Id + ".zip");
					if(InThread & this.EventUpdated != null) // Tell main windows to wake up
							this.EventUpdated(null, null);
					Directory.CreateDirectory(MySaveInfo[i].Id);
					Directory.SetCurrentDirectory(MySaveInfo[i].Id);
					ftp.Chdir(MySaveInfo[i].Id);
					FTPFile[] listtemp = ftp.DirDetails(@"");
					ftp.Mget(listtemp);
					ftp.Chdir(@"..");
					//Console.ReadLine();
					Console.WriteLine("Compressing " + MySaveInfo[i].Id + ".zip");
					Directory.SetCurrentDirectory(@"..");
					zip.Compress(MySaveInfo[i].Id, MySaveInfo[i].Id+".zip");
					Directory.Delete(MySaveInfo[i].Id, true);
					listtemp = null;
				}
				zip = null;
				Directory.SetCurrentDirectory(@"..");
				Disconnect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::BackupAllSaveGame):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		public void BackupOneSaveGame(string id)
		{
			try
			{
				Connect();
				ftp.TransferType = FTPTransferType.BINARY;
				ftp.Chdir(@"/E:/UDATA/");
				//ftp.Chdir(@"/home/webadm/test/UDATA/");
				if (!System.IO.Directory.Exists(@"saves"))
					System.IO.Directory.CreateDirectory(@"saves");
				Directory.SetCurrentDirectory(@"saves");
				ZipCompress zip = new ZipCompress();
	
				Directory.CreateDirectory(id);
				Directory.SetCurrentDirectory(id);
				
				ftp.Chdir(id);
				FTPFile[] listtemp = ftp.DirDetails(@"");
				ftp.Mget(listtemp);
				listtemp =null;
				ftp.Chdir(@"..");
				
				//Console.ReadLine();
				Console.WriteLine("Compressing " + id + ".zip");
				Directory.SetCurrentDirectory(@"..");
				zip.Compress(id, id + ".zip");
				Directory.Delete(id, true);
				zip = null;
				Directory.SetCurrentDirectory(@"..");
				Disconnect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::BackupOneSaveGame):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		public void PushOneSaveGame(string id)
		{
			try
			{
				Connect();
				ftp.TransferType = FTPTransferType.BINARY;
				//ftp.Chdir(@"/E:/UDATA/");
				ftp.Chdir(@"/home/webadm/test/UDATA/");
				Directory.SetCurrentDirectory(@"saves");
				Zip.Extract(id + ".zip", id, true);
				//Console.WriteLine(Directory.GetCurrentDirectory());
				ftp.Mkdir(id);
				ftp.Chdir(id);
				Directory.SetCurrentDirectory(id);
				string[] filenames = Directory.GetFiles(Directory.GetCurrentDirectory());
				string[] dirs = Directory.GetDirectories(Directory.GetCurrentDirectory());
				Adddir(dirs);

				foreach (string file in filenames) {
					ftp.Put(System.IO.Path.GetFileName(file), System.IO.Path.GetFileName(file));
				}

				Directory.SetCurrentDirectory(@"..");
				Directory.Delete(id, true);
				Directory.SetCurrentDirectory(@"..");
				filenames = dirs = null;
				Disconnect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox::PushOneSaveGame):" + ex.Message);
				#endif
				if (ftp != null)
					Disconnect();
				throw new Exception(ex.Message);
			}
		}
		
		public void Adddir(string[] dirnames)
		{
			foreach (string dir in dirnames) {
				/*Console.WriteLine("\n\n\tAdddir: " + dir + "\n" + 
				                  System.IO.Path.GetFileName(dir) + "\n" + 
				                  Directory.GetCurrentDirectory());*/
				Directory.GetDirectories(dir);
				string[] filenames = Directory.GetFiles(System.IO.Path.GetFileName(dir));
				ftp.Mkdir(System.IO.Path.GetFileName(dir));
				ftp.Chdir(System.IO.Path.GetFileName(dir));
				foreach (string file in filenames) {
					ftp.Put(file, System.IO.Path.GetFileName(file));
				}
				ftp.Chdir(@"..");
			}
		}
		#endif
	}
}
