#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/13 KaYa
/// first release
///
/// </summary>
#endregion

namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Reflection;
using System.Data;
using System.Text;
using System.IO;
using Gtk;
using Gdk;
using Glade;

	/// <summary>
	/// Description of Pref Galde Dialog.	
	/// </summary>
	public class ExportGladeDialog
	{
		private Gtk.Window mainwindow;
		
		public ExportGladeDialog(Gtk.Window gtkwindow) 
		{ 
			#if (DEBUG)
				Console.WriteLine("In ExportGlade::ExportGladeDialog");
			#endif
			this.mainwindow = gtkwindow;
			CreateGui();
		}
		
		[Glade.Widget] Gtk.Dialog 		dialog1;
		[Glade.Widget] Gtk.CheckButton	checkbutton7;
		[Glade.Widget] Gtk.CheckButton	checkbutton6;
		[Glade.Widget] Gtk.CheckButton	checkbutton5;
		[Glade.Widget] Gtk.CheckButton	checkbutton4;
		[Glade.Widget] Gtk.CheckButton	checkbutton3;
		[Glade.Widget] Gtk.CheckButton	checkbutton2;
		[Glade.Widget] Gtk.CheckButton	checkbutton1;

		public void CreateGui() 
		{
		 try{
				Glade.XML gxml = new Glade.XML (null, "uploaddir.glade", "ExportDialogGlade", null);
				dialog1 = (Gtk.Dialog) gxml["ExportDialogGlade"];
				checkbutton1 = (Gtk.CheckButton) gxml["checkbutton1"];
				checkbutton2 = (Gtk.CheckButton) gxml["checkbutton2"];
				checkbutton3 = (Gtk.CheckButton) gxml["checkbutton3"];
				checkbutton4 = (Gtk.CheckButton) gxml["checkbutton4"];
				checkbutton5 = (Gtk.CheckButton) gxml["checkbutton5"];
				checkbutton6 = (Gtk.CheckButton) gxml["checkbutton6"];
				checkbutton7 = (Gtk.CheckButton) gxml["checkbutton7"];
			    gxml.Autoconnect (this);
	
			   	dialog1.Title = "Exporting Information";
			   	dialog1.Icon = new Pixbuf(null, "xbgmicon.png");
			
				/*dialog1.Modal = true;
				dialog1.TransientFor = mainwindow;
				dialog1.WindowPosition = WindowPosition.CenterOnParent;
				*/
			}
			catch(Exception ex){
					Console.WriteLine("Error in ExportGlade::CreateGui" + ex.Message);
			}
		}

		public bool[] Run ()
		{
			dialog1.ShowAll();
			dialog1.Run();
			dialog1.Hide ();
			dialog1.Dispose ();
			bool[] colunmlist = new bool[7];
			colunmlist[0] = checkbutton7.Active; // icon
			colunmlist[1] = checkbutton1.Active; // Game
			colunmlist[2] = checkbutton2.Active;
			colunmlist[3] = checkbutton3.Active;
			colunmlist[4] = checkbutton4.Active;
			colunmlist[5] = checkbutton5.Active;
			colunmlist[6] = checkbutton6.Active; //region
			if (colunmlist.Length != 0)
				return colunmlist;
			else
				return null;
		}
		
		public void Close()
		{
			dialog1.Destroy();		
			System.GC.Collect();
		}
		
	}
}
