#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/08 KaYa
/// first release
///
/// </summary>
#endregion

using System;
using System.IO;

using ICSharpCode.SharpZipLib.Checksums;
using ICSharpCode.SharpZipLib.Zip;

namespace Xbgm.Core
{
	class ZipCompress
	{
		ZipOutputStream s;
		Crc32 crc;

		public void Compress(string dirname, string zipname)
		{
			string[] filenames = Directory.GetFiles(dirname);
			string[] dirs = Directory.GetDirectories(dirname);

			crc = new Crc32();
			s = new ZipOutputStream(File.Create(zipname));
			
			s.SetLevel(6); // 0 - store only to 9 - means best compression
			
			Adddir(dirs);
			
			foreach (string file in filenames) {
				FileStream fs = File.OpenRead(file);
				
				byte[] buffer = new byte[fs.Length];
				fs.Read(buffer, 0, buffer.Length);
				ZipEntry entry = new ZipEntry(file);
				
				entry.DateTime = DateTime.Now;
				
				// set Size and the crc, because the information
				// about the size and crc should be stored in the header
				// if it is not set it is automatically written in the footer.
				// (in this case size == crc == -1 in the header)
				// Some ZIP programs have problems with zip files that don't store
				// the size and crc in the header.
				entry.Size = fs.Length;
				fs.Close();
				
				crc.Reset();
				crc.Update(buffer);
				
				entry.Crc  = crc.Value;
				
				s.PutNextEntry(entry);
				
				s.Write(buffer, 0, buffer.Length);
			}
			s.Finish();
			s.Close();
		}
		
		public void Adddir(string[] dirnames)
		{
			foreach (string dir in dirnames) {
				//Console.WriteLine(dir);
				string[] filenames = Directory.GetFiles(dir);
					
				foreach (string file in filenames) {
					FileStream fs = File.OpenRead(file);
					
					byte[] buffer = new byte[fs.Length];
					fs.Read(buffer, 0, buffer.Length);
					ZipEntry entry = new ZipEntry(file);
					
					entry.DateTime = DateTime.Now;
	
					entry.Size = fs.Length;
					fs.Close();
					
					crc.Reset();
					crc.Update(buffer);
					
					entry.Crc  = crc.Value;
					
					s.PutNextEntry(entry);
					
					s.Write(buffer, 0, buffer.Length);
				}
			}
		}
	}
}
