static char rcsid[] = "$Id: Ftpfopen.c,v 5.0 1995/12/10 10:28:38 orel Exp $";

/*
	$Log: Ftpfopen.c,v $
 * Revision 5.0  1995/12/10  10:28:38  orel
 * LIBFTP Version 5.0 (Distributed revision)
 *
 * Revision 4.1  1995/12/02  11:23:07  orel
 * *** empty log message ***
 *
 * Revision 4.0  1995/07/11  07:00:26  orel
 * Libftp Version 4.0
 *
 * Revision 4.0  1995/07/11  07:00:26  orel
 * Libftp Version 4.0
 *
 * Revision 3.1  1995/06/20  15:53:50  orel
 * Porting to AIX
 *
 * Revision 3.0  1995/03/20  05:26:07  orel
 * *** empty log message ***
 *
 * Revision 2.4  1995/03/20  05:18:13  orel
 * *** empty log message ***
 *
 * Revision 2.3  1995/02/26  16:46:50  orel
 * *** empty log message ***
 *
 * Revision 2.3  1995/02/26  16:46:50  orel
 * *** empty log message ***
 *
 * Revision 2.2  1995/02/18  15:42:53  orel
 * modify for recurive mget
 *
 * Revision 2.2  1995/02/18  15:42:53  orel
 * modify for recurive mget
 *
 * Revision 2.1  1995/02/04  09:02:53  orel
 * add rcsid
 *
 * Revision 2.1  1995/02/04  09:02:53  orel
 * add rcsid
 *

*/
/*
		      Library for ftpd clients.(libftp)
			Copyright by Oleg Orel
			 All rights reserved.
			
This  library is desined  for  free,  non-commercial  software  creation. 
It is changeable and can be improved. The author would greatly appreciate 
any  advises, new  components  and  patches  of  the  existing  programs.
Commercial  usage is  also  possible  with  participation of it's author.



*/

#include <FtpLibrary.h>

#define NFSD 256

static int fds_types[FTP_NFDS];
static int init=0;

enum {T_EMPTY=0,T_FILE,T_STREAM,T_PIPE,T_FULL};

FILE *Ftpfopen(char *filename,char *mode)
{
  FILE *fp;
  
  if (!init)
    { 
      bzero(fds_types,FTP_NFDS*sizeof(fds_types[0]));
      init=1;
    }

  if (!strcmp(filename,"*STDIN*") || (!strcmp(filename,"-") && (mode[0]=='r')) )
    {
      fds_types[fileno(stdin)]=T_STREAM;
      return stdin;
    }
  
  if (!strcmp(filename,"*STDOUT*") || (!strcmp(filename,"-") && (mode[0]=='w')))
    {
      fds_types[fileno(stdout)]=T_STREAM;
      return stdout;
    }
  
  if (strcmp(filename,"*STDERR*")==0)
    {
      fds_types[fileno(stderr)]=T_STREAM;
      return stderr;
    }
  


  if (*filename=='|') 
    {
      fp=popen(filename+1,mode);
      if (fp==NULL) return fp;
      fds_types[fileno(fp)]=T_PIPE;
      return fp;
    }

  fp=fopen(filename,mode);
  if (fp==NULL) return fp;
  fds_types[fileno(fp)]=T_FILE;
  return fp;
  
}

int Ftpfclose(FILE *fp)
{

  if (!init)
    { 
      bzero(fds_types,FTP_NFDS*sizeof(fds_types[0]));
      init=1;
    }

  switch (fds_types[fileno(fp)])
    {
    
    case T_FILE:
      
      return fclose(fp);
      
    case T_STREAM:

      return fflush(fp);
      
    case T_PIPE:
      
      return pclose(fp);
      
    default:

      return -1;
    }

}



