#!/usr/bin/perl
# 
# XSAVE 0.0.1 - 21/2/5  Thomas GUTHMANN  [tom@calixo.net]
# You need to have Net::FTP =>  apt-get install libnet-perl
# Enjoy ;)
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

use Net::FTP;
use Data::Dumper;
use Cwd;
use lib '.';
use Recursive;
use vars qw/ %opt /;
use strict;

# /!\  CHECK THIS /!\
# You probably need to modify the $xbox or maybe add
# a new "xbox" entry in your /etc/hosts with the good ip.
# As you want ;)
my $xbox="xbox";
my $username="xbox";
my $password="xbox";
my $directory="/E/UDATA/";


#
# LIST ALL SAVE GAMES
#
sub xlist
{
	my ($debug) = @_;
	unless($debug == 0 || $debug == 1)
	{
		$debug = 0;
	}
	my $ftp = Net::FTP->new($xbox, Debug => $debug) or die "Can't connect: $@\n";
	$ftp->login($username, $password) or die "Couldn't login\n";
	$ftp->cwd($directory) or die "Couldn't change directory\n";
	my @lines = $ftp->dir($ftp->pwd())
		or die "Can't get a list of files in $directory : $!";
	my $i;
	for $i ( 0 .. $#lines )
	{
		my($d,$none,$none,$none,$none,$month,$day,$hour,$dir)=split(/\s+/,$lines[$i]);
		if( $d =~ /^d/ )
		{
			my $remotefile=$directory.$dir.'/TitleMeta.xbx';
			$ftp->get($remotefile,'/tmp/TitleMeta.xbx') 
				or die "Can't fetch $remotefile: $!\n";
			open(F,'< /tmp/TitleMeta.xbx')
				or die "Can't find /tmp/TitleMeta.xbx : $!\n";
			while (my $l = <F>)
			{
				# quick hack
				chomp($l);	
				chop($l);	
				chop($l);	
				chop($l);	
				# end of da dirty hack
				if($l =~ /=(.*)/)
				{
					print "[$dir] $1\n";
					last;
				}
			}
			close(F);
		}
	}
	# cleaning things
	unlink('/tmp/TitleMeta.xbx');
	$ftp->quit()    or warn "Couldn't quit.  Oh dude!.\n";
	return(0);
}


#
# PARSER
#
sub init
{
    use Getopt::Std;
    my $opt_string = 'hdltg:';
	my $debug=0;
	my $tarball=0;
    getopts( "$opt_string", \%opt ) or &usage;

	$debug=1 if $opt{d};
	$tarball=1 if $opt{t};

    &usage if($opt{h});
	&xlist($debug) if $opt{l};
	&xget($opt{g},$tarball,$debug) if $opt{g};
	

}

#
# RGET
#
sub xget
{
	my $path=getcwd();
	my ($id,$tarball,$debug)=@_;	
	if(length($id)==8)
	{
		my $ftp = Net::FTP::Recursive->new($xbox, Debug => $debug) or die "Can't connect: $@\n";
		$ftp->login($username, $password) or die "Couldn't login\n";
		$ftp->cwd($directory.'/'.$id) or die "Couldn't change directory: $id\n";
		$ftp->binary();
		mkdir($id) or die "I cannot my create my $id local directory! What's going on here ;)";
		chdir($id);
		$ftp->rget();
		chdir('..');   #get back;
		if($tarball == 1)
		{
			system("tar cvzf $id.tgz $id/");
			$path .= '/'.$id ;  # absolute path 
			system("rm -rf $id/");
		}
		$ftp->quit;
	}
	else
	{
		print STDERR "\nYou probably miss/add a number!\n\n";
		exit(-1);
	}

}

#
# USAGE / HELP
#
sub usage
{
	print STDERR << "EOF";

	Show and retrieve XBOX savegames. Version = 0.0.1
	tom\@calixo.net 21/2/5	

	usage: $0 <-lg> [-hdt]

	 -h        : this (help) message
	 -l        : list all IDs of the XBOX's savegames
	 -g <ID>   : get the save <ID> as a directory
	 -t        : need -g to work. Tarball the results
	 -d        : debug

	example: $0 -g 45410049 

EOF

    exit;
}


# 
# <<<< MAIN >>>>
#
    &init;
