/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-19 at 00:23

namespace Xbgm.Xiso
{
	public class Info
	{
		private string xisofilename;

		private double totisofile;

		private double totsizefile;

		private string ISOFileName;

		private string xboxdir;

		private string gamedir;

		private bool hdd;

		private Xbgm.FTP.Configuration FTPinfo;

		public Info()
		{
			System.Console.WriteLine("Loading default Xiso.");
		}
		
		public Info(string xisofilename, double totisofile, double totsizefile,
					string ISOFileName, string xboxdir, string gamedir, bool hdd,
					Xbgm.FTP.Configuration FTPinfo)
		{
			this.xisofilename = xisofilename;
			this.totisofile = totisofile;
			this.totsizefile = totsizefile;
			this.ISOFileName = ISOFileName;
			this.xboxdir = xboxdir;
			this.gamedir = gamedir;
			this.hdd = hdd;
			this.FTPinfo = FTPinfo;
		}

		public string getXisoFileName() { return this.xisofilename; }
		public double getNbrFiles() { return this.totisofile; }
		public double getSize() { return this.totsizefile; }
		public string getISOFileName() { return this.ISOFileName; }
		public string getXboxDirectory() { return this.xboxdir; }
		public string getGameDirectory() { return this.gamedir; }
		public bool getHdd() { return this.hdd; }
		public string getFtpUser() { return this.FTPinfo.getUser(); }
		public string getFtpPassword() { return this.FTPinfo.getPassword(); }
		public string getFtpIp() { return this.FTPinfo.getIp(); }
		public int getFtpPort() { return this.FTPinfo.getPort(); }
	}
}
