/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-19 at 16:50

using EnterpriseDT.Net.Ftp;
using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace Xbgm.Core
{
	public delegate void Notifier(string[] rootspace);
	
	public class FtpToXbox
	{	
		public event Notifier notifyViews;
		public Action action = Action.ready;
		public Parser.Summary gameSummary;
		
		private Xbgm.Configuration cfg;
		private Xbgm.Core.Messages msg;
		private Xbgm.Core.Parser parser;
		
		private FTPClient ftp;
				
		// Constructor
		public FtpToXbox(Xbgm.Configuration cfg,
							Messages msg)
		{
			this.cfg = cfg;
			this.msg = msg;
			this.parser = new Parser(cfg);
		}
		 
		public enum Action
			{
				ready, scan, rename, delete, launch, reboot, shutdown,
				xbmc, image, freespace,	allfreespace, format, refresh
			};
			
		public void ChangeLabelResults(string[] rootspace)
		{
			notifyViews(rootspace);
		}
		
		private void Connect()
		{
			try
			{
				//UpdateStatusBar("FTP job Start.");
				// Create socket
				//FTPClient ftp = new FTPClient(FTPinfo.getIp(), FTPinfo.getPort(), null, 2);
				ftp = new FTPClient(cfg.getFtpInfo().getIp(), cfg.getFtpInfo().getPort());
				#if ( DEBUG )
					ftp.DebugResponses(true);
				#endif
				// Login
				ftp.Login(cfg.getFtpInfo().getUser(), cfg.getFtpInfo().getPassword());
				ftp.System();
				// Crash on Linux
				//ftp.Timeout = 10;
			}
			catch (FTPException ex) 
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				// Got a problem when launch in thread
				//OnError(ex.Message);
				// TO refresh the statusbar and stop gtk timer;
				this.action = Action.ready;
			} // For some reason, this one works, the other one not.
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in FtpToXbox): " + ex.Message);
				#endif
				this.action = Action.ready;
				// Make sure methods get to know it.
				throw new Exception("Can't connect to Xbox.");
			} 
		}
		
		private void Disconnect()
		{
			// The default quit wait for a reply but there is none
			// so it crash, need to catch exception
			// or do it like this, I made my own Quit with out reply
			
			try
			{
				ftp.QuitXbox();
				ftp = null;
			}
			catch (FTPException ex)
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				// Got a problem when launch in thread
				//OnError(ex.Message);
				// TO refresh the statusbar and stop gtk timer;
				this.action = Action.ready;
			}
			System.GC.Collect();
		}
		

		public bool DeleteGame(ArrayList game, bool deleteSaveGames)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}

			try 
			{
				ftp.TransferType = FTPTransferType.BINARY;
				
				// I don't know why but they do it
				ftp.Site("FREEROOTSPACEDISABLE ");			
				
											// xbe full path
				bool ok = ftp.Site("DELTREE " + game[2]);			
				if(ok == false)
				{
					// then we do it the old way
					ftp.Rmdir(game[2].ToString());
				}
				
				if(deleteSaveGames)
				{										//ID
					ok = ftp.Site(@"DELTREE /E:/UDATA/" + game[3]);
					ok = ftp.Site(@"DELTREE /E:/TDATA/" + game[3]);
				}
			}
			catch (FTPException ex)
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				this.action = Action.ready;
			}
			
			Disconnect();
			
			return true;
		}
		
		public bool RenameGame(ArrayList game, string newGameName)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}
			
			ftp.TransferType = FTPTransferType.BINARY;
			ftp.Site("XBERENAME \"" + game[2] + game[1] + "\" " + newGameName);			
			Disconnect();
			return true;
		}
		
		public bool LaunchGame(ArrayList game)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				return false;
			}
			ftp.TransferType = FTPTransferType.BINARY;
			ftp.Site("LAUNCH " + game[2] + game[1]);			
			Disconnect();
			return true;
		}
		
		public void FormatDrive(string drive)
		{
			Connect();
			#if ( DEBUG )
				Console.WriteLine("Format drive " + drive);
			#endif
			// DriveSelected string
			ftp.Site("FORMAT " + drive);

			Disconnect();
		}
		
		public void ActionNotOnGame(Action xboxAction)
		{
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
				throw ex;
			}
			
			this.action = xboxAction;
			
			switch(this.action) 
			{
				case Action.shutdown: // Shutdown
				{
					ftp.Site("SHUTDOWN");			
					break;
				}

				case Action.reboot: // Restart
				{
					ftp.Site("REBOOT");			
					break;
				}

				case Action.xbmc: // Launch XBMC
				{
					ftp.TransferType = FTPTransferType.BINARY;
	
					// XBMC xbe full path
					ftp.Site("LAUNCH " + cfg.getXBMC());			
					break;
				}
					
				case Action.refresh: // Refresh Avalaunch menu
				{
					ftp.TransferType = FTPTransferType.BINARY;
	
					// Refresh Avalaunch menu
					ftp.Site("REFRESH");			
					break;
				}
					
				default:            
           			Console.WriteLine("Invalid Action, has to be shutdown, reboot , refresh or xbmc.");            
           			break;  

			}
			
			Disconnect();
		}

		public string GetTitlesCached()
		{
			string freespace = "N/A";
			
			this.gameSummary = parser.TitlesCached();
			this.action = Action.ready;
			
			return freespace;			
		} // End of GetTitlesCached
		
		public string GetTitles(bool getIcons)
		{
			string freespace = "N/A";
			
			try
			{
				Connect();
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Caught exception (in GetTitles):" + ex.Message);
				#endif
				throw new Exception(ex.Message);
			}
			
			if (ftp.Site("FREEROOTSPACEENABLE") == false) // Check for avalaunch
			{
				Console.WriteLine("This feature requires Avalaunch, or a newer version.");
				this.action = Action.ready;
				return freespace;
			}
			ftp.TransferType = FTPTransferType.BINARY;
			// Do all command and get titles game in a string[]
			// The problem of this is than i need to wait to recevied the all list of Game
			gameSummary = parser.Titles(ftp.GetTitles(cfg.getFtpInfo().getDirectory()));
			
			// Check if i need to DL icons
			if (getIcons)
			{
				this.action = Action.image;
				ftp.Site("TITLEIMAGES");
				ftp.Get(@"titleimage.zip", @"/Z:/titleimage.zip");
				Zip.Extract(@"titleimage.zip");
			}
			this.action = Action.ready;
			
			// List free space Game Drive
			ftp.Site("FREEROOTSPACEENABLE");
			string[] rootspace = ftp.Dir("/", true);
			foreach(string space in rootspace)
			{
				//Console.WriteLine("Space:" + space + "]");
				string[] free = space.Split(' ');
				//Console.WriteLine("[" + free[24].ToString() +"] == [" +FTPinfo.getDirectory().Substring(0, 2) +"]");
				if(free[24].Equals(cfg.getFtpInfo().getDirectory().Substring(0, 2)))
				{
					#if (DEBUG)
						Console.WriteLine("Free Space:" + free[26].ToString());
					#endif
					freespace = free[26].ToString() + " MB";
				}
			}
				
			// List free space for all Drive
			if (ftp.Site("FREEROOTSPACEENABLE") == true)
			{
				rootspace = ftp.Dir("/", true);
				// Updating Views
				this.ChangeLabelResults(rootspace);
				rootspace = null;
				ftp.Site("FREEROOTSPACEDISABLE");
			}
						
			Disconnect();
			
			return freespace;			
		} // End of GetTitles
		
		public bool GetFreeSpace(string xboxDir, UInt32 size)
		{
			bool freespace = false;
			
			Connect();
			
			ftp.TransferType = FTPTransferType.BINARY;

			if (ftp.Site("FREEROOTSPACEENABLE") == true)
			{
				string[] rootspace = ftp.Dir("/", true);
				foreach(string space in rootspace)
				{
					//Console.WriteLine("Space:" + space + "]");
					string[] free = space.Split(' ');
					//Console.WriteLine("[" + free[24].ToString() +"] == [" + Entryxboxdir.Text.Substring(0, 2) +"]");
					if(free[24].Equals(xboxDir))
					{
						//Console.WriteLine("we need:" + fspace[0] + " and we have:" + free[26]);
						if (size > Convert.ToUInt32(free[26]))
							msg.Info("You don't enough free space on " + xboxDir);
						else
							freespace = true;
					}
					free = null;
				}
				rootspace = null;
				ftp.Site("FREEROOTSPACEDISABLE");	
			}
			else
			{ // Not using Avalaunch
				#if ( DEBUG )
					Console.WriteLine("Not using Avalaunch");
				#endif
				freespace = true;		
			}
			
			Disconnect();
			return freespace;
		}

		public Xbgm.Configuration getConfiguration()
		{
			return this.cfg;
		}
		
		public void setConfiguration(Xbgm.Configuration cfg)
		{
			this.cfg = cfg;
		}
	}
}
