unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPServer,IdIOHandlerSocket,IdStackConsts,
  IdAntiFreezeBase, IdAntiFreeze, ComCtrls, Menus, DB, DBClient, DBCtrls,
  ExtCtrls, Grids, DBGrids, Buttons;

type
  TForm1 = class(TForm)
    IdTCPServer1: TIdTCPServer;
    IdAntiFreeze1: TIdAntiFreeze;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    TabSheet6: TTabSheet;
    ScrollBox1: TScrollBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    ListView1: TListView;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    ClientDataSet1: TClientDataSet;
    ClientDataSet1Directory: TStringField;
    ClientDataSet1filemask: TStringField;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    procedure IdTCPServer1Connect(AThread: TIdPeerThread);
    procedure IdTCPServer1Disconnect(AThread: TIdPeerThread);
    procedure ClientDataSet1BeforeOpen(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
    procedure ClientDataSet1AfterPost(DataSet: TDataSet);
    procedure SpeedButton1Click(Sender: TObject);
  private
    procedure rescanmedia;
  end;

var
  Form1: TForm1;

implementation

uses IdTCPConnection, downloadframe, IdSocketHandle;

{$R *.dfm}
Function MAX(s:String;L:integer):String;
Begin
  Result := s;
  while length(result)<l do result := result + ' ';
End;

function GetNextParam(var param:String):String;
var
  tmp : String;
Begin
  tmp := '';
  While (length(param)>0) and (param[1]<>',') do
    Begin
      tmp := tmp + param[1];
      delete(param,1,1);
    End;
  delete(param,1,1);
  Result := tmp;
End;

procedure TForm1.IdTCPServer1Connect(AThread: TIdPeerThread);
var
  Greeting : String;
  command : String;
  tmp:String;
  param : String;
  x:Longint;
  done : Boolean;
  MediaStream : TFileStream;
  Response : String;
  ResponseData : String;
  lastpos : Longint;
  buf:array[1..600000] of byte;
  bufzise : Longint;
  dlstatus : Tdlstatus;
begin
  // need nodelay for FAST streaming!
  (aThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.SetSockOpt(Id_IPPROTO_TCP, Id_TCP_NODELAY, PChar(@Id_SO_True), SizeOf(Id_SO_True));
  memo1.Lines.Add('');
  memo1.Lines.Add('');
  memo1.Lines.Add('');
  memo1.Lines.Add('Trying handshake');
  Greeting := aThread.Connection.ReadLn(#10,4000,2000);
  memo1.Lines.Add('received greeting :'+greeting);
  memo1.lines.add('Sending greeting : HELLO XBOX!');
  aThread.connection.Write('HELLO XBOX!');

  AThread.Connection.ReadTimeout:=1000;
  memo1.lines.add('Waiting in endles loop for commands');
  done := false;
  memo1.lines.add('sendbuffersize = '+Inttostr(aThread.Connection.SendBufferSize));
  aThread.Connection.SendBufferSize := 5;
//  memo1.lines.add('sendbuffersize = '+Inttostr(aThread.Connection.RecvBufferSize));
//  aThread.Connection.RecvBufferSize := 5;
  aThread.Priority := tpHighest;
  Lastpos := 0;
  dlstatus := nil;
  While not done do
    Begin
      done := False;
      Response := '-1 UNKNOWN ERROR';
      ResponseData := '';
      bufzise := 0;

      command := aThread.Connection.ReadString(4);
      if command='' then
        memo1.lines.Text := memo1.lines.text+'no command'
      else
        Begin
          if command<>'READ' then
            Memo1.lines.add('Command gotten : '+command);
          if command = '*CAT' then
            Begin
              tmp := '';
              tmp := tmp + '<SHARES>'+#13#10;
              for x:= 0 to ListView1.Items.Count-1 do
                tmp := tmp + '<ITEM><PATH>'+Listview1.Items[x].SubItems[0]+Listview1.Items[x].Caption+'</PATH></ITEM>';
              tmp := tmp + '</SHARES>'+#13#10;
              Response := inttostr(length(tmp))+' OK';
              ResponseData := tmp;

              Done := True;
            End;
          if command = 'OPEN' then
            Begin
              memo1.lines.Add('reading OPEN param');
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              memo1.lines.Add(' param '+param);
              if fileExists(param) then
                Begin
                  MediaStream := TFileStream.Create(param,fmOpenRead);
                  Response := Inttostr(MediaStream.Size)+' OK';
                  dlstatus := tdlstatus.Create(self);
                  dlstatus.Align:= alTop;
                  dlstatus.Parent := scrollbox1;
                  dlstatus.Show;
                  dlstatus.lblFilename.Caption := extractfilename(param);
                  dlstatus.PbarPosition.MaxValue := MediaStream.Size;
                  dlstatus.PbarPosition.Progress := 0;
                  dlstatus.PbarPosition.MinValue := 0;

                  dlstatus.lblRemoteIP.Caption := (AThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.PeerIP;
                  application.ProcessMessages;
                  memo1.lines.Add(' File Found ');
                  Lastpos := 0;
                end
              else
                Begin
                  Response := '-1 UNABLE TO OPEN';
                  memo1.lines.Add(' File not found');
                End;
              Done := False;
            End;

          if command = 'INFO' then
            Begin
              memo1.lines.Add('reading INFO param');
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              memo1.lines.Add(' param '+param);
              tmp := '<media><share>scary</share><title>'+TimeToStr(now)+'</title><artists>me</artists><summary>duno</summary>'{<picture></picture>}+'</media>';
              //              aThread.Connection.Write(max('-1 NO INFO',32));
              Response := inttostr(length(tmp))+' OK';
              ResponseData := tmp;
              Done := True;
            end;

          if command = 'READ' then
            Begin
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              Done := False;
              if assigned(MediaStream) then
                Begin
                  tmp := GetNextParam(param);
                  x:=StrToInt(Tmp);
                  if lastpos <> x then
                    MediaStream.Position := x;
                  tmp := GetNextParam(param);
                  x:= StrToInt(tmp);
                  bufzise := MediaStream.Read(buf,x);
                  lastpos := lastpos + bufzise;
                  if assigned(dlstatus) then
                    dlstatus.PbarPosition.Progress := lastpos;
                  Response := inttostr(bufzise)+' OK';
                  ResponseDAta := '';
                End
              Else
                Response := '-1 READ FAILED';
            end;
          if command = 'TELL' then
            Begin
              if assigned(MediaStream) then
                Response := Inttostr(MediaStream.Position)+' OK'
              Else
                Response := '-1 TELL FAILED';
            end;

          if command = 'CLSE' then
            Begin
              FreeAndNil(MediaStream);
              Response := '0 OK';
              Done := True;
            end;

          if command = 'DBUG' then
            Begin
              Response := '0 OK';
            end;

          Response := MAX(Response,32);
          aThread.Connection.WriteBuffer(Response[1],Length(Response),true);
          if ResponseData <> '' then
            aThread.Connection.WriteBuffer(Responsedata[1],Length(Responsedata),true);
          if bufzise <> 0 then
            aThread.Connection.WriteBuffer(buf,bufzise,true);
          if done then
            aThread.Connection.Disconnect;
          application.ProcessMessages;
        End;
    End;
  memo1.lines.add('End of it all');
  FreeAndNil(dlstatus);
end;



procedure TForm1.IdTCPServer1Disconnect(AThread: TIdPeerThread);
begin
  Memo1.Lines.add('Disconnected');
end;


procedure TForm1.ClientDataSet1BeforeOpen(DataSet: TDataSet);
begin
  ClientDataSet1.filename := ExtractFilePath(ParamStr(0))+'directories.cds';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  rescanmedia;
end;

procedure TForm1.rescanmedia;
  procedure scandir(dir:String;mask:String);
  var
    diri:TSearchrec;
    res:Integer;
    item:tlistitem;
  begin
    Res := FindFirst(dir+mask,faAnyFile,diri);
    while res=0 do
      Begin
        item := ListView1.Items.add;
        item.Caption := diri.Name;
        item.SubItems.Add(dir);
        item.SubItems.Add(inttostr(diri.size));
        res := findnext(diri);
      End;
  end;

begin
 ListView1.Items.Clear;
 ClientDataSet1.First;
 while not ClientDataSet1.Eof do
   Begin
     scandir(ClientDataSet1Directory.AsString,ClientDataSet1filemask.AsString);
     ClientDataSet1.Next;
   End;
//
end;

procedure TForm1.ClientDataSet1AfterPost(DataSet: TDataSet);
begin
  rescanmedia;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if opendialog1.Execute then
    begin
      ClientDataSet1.Edit;
      ClientDataSet1Directory.AsString := ExtractFilePath(OpenDialog1.FileName);
      ClientDataSet1.Post;
    end;
end;

end.
