/*
 * Copyright (C) 2003 Sanjay Madhavan.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.revasoft.shoutcast.plsdownloader;

public class PlsOptions {
	private static final String VERSION = "V1.1";
	private String oDownloadDirectory = "Shoutcast";
	private String oProcessGenre = null;
	private int oMaxFilesPerGenre = 50;
	private String oProxyList = null;
	private String oGenreList = null;
	private boolean oIgnoreSavedState = false;
	private String oMinimumBitRate = null;
	private String oMaximumBitRate = null;

	/**
	 * @param args
	 */
	public PlsOptions(String[] args) {

		for (int i = 0; i < args.length; i++) {
			String arg = args[i].toLowerCase();
			if (arg.equalsIgnoreCase("-DownloadDirectory")) {
				i++;
				setDownloadDirectory(args[i]);
			} else if (arg.equalsIgnoreCase("-MaxFilesPerGenre")) {
				i++;
				setMaxFilesPerGenre(Integer.parseInt(args[i]));
			} else if (arg.equalsIgnoreCase("-ProcessGenre")) {
				i++;
				setProcessGenre(args[i]);
			} else if (arg.equalsIgnoreCase("-GenreList")) {
				i++;
				setGenreList(args[i]);
			} else if (arg.equalsIgnoreCase("-ProxyList")) {
				i++;
				setProxyList(args[i]);
			} else if (arg.equalsIgnoreCase("-IgnoreSavedState")) {
				setIgnoreSavedState(true);
			} else if (arg.equalsIgnoreCase("-MinimumBitRate")) {
				i++;
				setMinimumBitRate(args[i]);
			} else if (arg.equalsIgnoreCase("-MaximumBitRate")) {
				i++;
				setMaximumBitRate(args[i]);
			} else {
				System.out.println(
					"WARNING: Ignoring Unknown parameter: " + args[i]);
			}
		}

	}

	public String getLogString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n\tPlsDownloader " + VERSION + " : ");
		sb.append("\n\tDownloadDirectory=" + getDownloadDirectory());

		sb.append("\n\tMaxFilesPerGenre=" + getMaxFilesPerGenre());
		if (getProcessGenre() != null) {

			sb.append("\n\tProcessGenre=" + getProcessGenre());
		}
		if (getProxyList() != null) {

			sb.append("\n\tProxyList=" + getProxyList());
		}
		if (getGenreList() != null) {

			sb.append("\n\tGenreList=" + getGenreList());
		}
		if (isIgnoreSavedState()) {

			sb.append("\n\tIgnoreSavedState=" + isIgnoreSavedState());
		}
		if (getMinimumBitRate() != null) {

			sb.append("\n\tMinimumBitRate=" + getMinimumBitRate());
		}
		if (getMaximumBitRate() != null) {

			sb.append("\n\tMaximumBitRate=" + getMaximumBitRate());
		}
		return sb.toString();

	}

	/**
	 * @return Returns the downloadDirectory.
	 */
	public String getDownloadDirectory() {
		return oDownloadDirectory;
	}

	/**
	 * @return Returns the maxFilesPerGenre.
	 */
	public int getMaxFilesPerGenre() {
		return oMaxFilesPerGenre;
	}

	/**
	 * @param downloadDirectory
	 *            The downloadDirectory to set.
	 */
	public void setDownloadDirectory(String downloadDirectory) {
		oDownloadDirectory = downloadDirectory;
	}

	/**
	 * @param maxFilesPerGenre
	 *            The maxFilesPerGenre to set.
	 */
	public void setMaxFilesPerGenre(int maxFilesPerGenre) {
		oMaxFilesPerGenre = maxFilesPerGenre;
	}

	/**
	 * @return Returns the startGenre.
	 */
	public String getProcessGenre() {
		return oProcessGenre;
	}

	/**
	 * @param startGenre
	 *            The startGenre to set.
	 */
	public void setProcessGenre(String startGenre) {
		oProcessGenre = startGenre;
	}

	/**
	 * @param proxyList
	 *            The proxyList to set.
	 */
	public void setProxyList(String proxyList) {
		oProxyList = proxyList;
	}

	/**
	 * @return Returns the proxyList.
	 */
	public String getProxyList() {
		return oProxyList;
	}

	/**
	 * @return Returns the ignoreSavedState.
	 */
	public boolean isIgnoreSavedState() {
		return oIgnoreSavedState;
	}

	/**
	 * @param ignoreSavedState
	 *            The ignoreSavedState to set.
	 */
	public void setIgnoreSavedState(boolean ignoreSavedState) {
		oIgnoreSavedState = ignoreSavedState;
	}

	/**
	 * @return Returns the minimumBitRate.
	 */
	public String getMinimumBitRate() {
		return oMinimumBitRate;
	}

	/**
	 * @param minimumBitRate
	 *            The minimumBitRate to set.
	 */
	public void setMinimumBitRate(String minimumBitRate) {
		oMinimumBitRate = minimumBitRate;
	}

	/**
	 * @return Returns the maximumBitRate.
	 */
	public String getMaximumBitRate() {
		return oMaximumBitRate;
	}

	/**
	 * @param maximumBitRate
	 *            The maximumBitRate to set.
	 */
	public void setMaximumBitRate(String maximumBitRate) {
		oMaximumBitRate = maximumBitRate;
	}

	/**
	 * @return Returns the genreList.
	 */
	public String getGenreList() {
		return oGenreList;
	}

	/**
	 * @param genreList
	 *            The genreList to set.
	 */
	public void setGenreList(String genreList) {
		oGenreList = genreList;
	}

}
