/*
 * Created on Aug 5, 2003
 *
 */
package com.revasoft.jmp3tagextractor;

import java.io.File;

/**
 * Utility class to capture all options that can be used while invoking the Mp3ImageTagExtractor
 * 
 * @author Sanjay Madhavan
 *
 */
public class Mp3ImageTagExtractorOptions {
	private String fileMask = "*.mp3";
	private String targetFileExtension = null;
	private String targetDirectory = null;
	//
	private boolean overwriteExisting = false;
	//
	private boolean skipCreateAlbumThumbNail = false;
	private boolean skipCreateArtistThumbNail = false;
	private boolean skipCreateTrackThumbNail = false;
	//	
	private boolean resize = false;
	private int resizeWidth = 64;
	private int resizeHeight = 64;
	//
	private String logFileName = "Mp3ImageTagExtractor.log";
	private File logFile = null;

	private String sourceDir = null;
	private String sourceFile = null;
	private String targetFile = null;

	/**
	 * Expects an sizeString in format WidthxHeight (e.g. 64x75 = width=64, height=75)
	 * 
	 * @param sizeString
	 */
	public void parseImageSize(String sizeString) {
		int idx = sizeString.indexOf('x');
		if (idx > 0 && idx < sizeString.length()) {
			setResizeWidth(Integer.parseInt(sizeString.substring(0, idx)));
			setResizeHeight(Integer.parseInt(
				sizeString.substring(idx + 1, sizeString.length())));

		}

	}
	/**
	 * @return
	 */
	public String getSourceDir() {
		return sourceDir;
	}

	/**
	 * @param sourceDir
	 */
	public void setSourceDir(String sourceDir) {
		this.sourceDir = sourceDir;
	}

	/**
	 * @return
	 */
	public String getSourceFile() {
		return sourceFile;
	}

	/**
	 * @param sourceFile
	 */
	public void setSourceFile(String sourceFile) {
		this.sourceFile = sourceFile;
	}

	/**
	 * @return
	 */
	public String getTargetFile() {
		return targetFile;
	}

	/**
	 * @param targetFile
	 */
	public void setTargetFile(String targetFile) {
		this.targetFile = targetFile;
	}

	/**
	 * @return
	 */
	public String getFileMask() {
		return fileMask;
	}

	/**
	 * @param fileMask
	 */
	public void setFileMask(String fileMask) {
		this.fileMask = fileMask;
	}

	/**
	 * @return
	 */
	public File getLogFile() {
		if (logFile == null)
			logFile = new File(getLogFileName());
		return logFile;
	}

	/**
	 * @param logFile
	 */
	public void setLogFile(File logFile) {
		this.logFile = logFile;
	}

	/**
	 * @return
	 */
	public String getLogFileName() {
		return logFileName;
	}

	/**
	 * @param logFileName
	 */
	public void setLogFileName(String logFileName) {
		this.logFileName = logFileName;
	}

	/**
	 * @return
	 */
	public boolean isOverwriteExisting() {
		return overwriteExisting;
	}

	/**
	 * @param overwriteExisting
	 */
	public void setOverwriteExisting(boolean overwriteExisting) {
		this.overwriteExisting = overwriteExisting;
	}

	/**
	 * @return
	 */
	public boolean isResize() {
		return resize;
	}

	/**
	 * @param resize
	 */
	public void setResize(boolean resize) {
		this.resize = resize;
	}

	/**
	 * @return
	 */
	public int getResizeHeight() {
		return resizeHeight;
	}

	/**
	 * @param resizeHeight
	 */
	public void setResizeHeight(int resizeHeight) {
		this.resizeHeight = resizeHeight;
	}

	/**
	 * @return
	 */
	public int getResizeWidth() {
		return resizeWidth;
	}

	/**
	 * @param resizeWidth
	 */
	public void setResizeWidth(int resizeWidth) {
		this.resizeWidth = resizeWidth;
	}

	/**
	 * @return
	 */
	public boolean isSkipCreateAlbumThumbNail() {
		return skipCreateAlbumThumbNail;
	}

	/**
	 * @param skipCreateAlbumThumbNail
	 */
	public void setSkipCreateAlbumThumbNail(boolean skipCreateAlbumThumbNail) {
		this.skipCreateAlbumThumbNail = skipCreateAlbumThumbNail;
	}

	/**
	 * @return
	 */
	public boolean isSkipCreateArtistThumbNail() {
		return skipCreateArtistThumbNail;
	}

	/**
	 * @param skipCreateArtistThumbNail
	 */
	public void setSkipCreateArtistThumbNail(boolean skipCreateArtistThumbNail) {
		this.skipCreateArtistThumbNail = skipCreateArtistThumbNail;
	}

	/**
	 * @return
	 */
	public boolean isSkipCreateTrackThumbNail() {
		return skipCreateTrackThumbNail;
	}

	/**
	 * @param skipCreateTrackThumbNail
	 */
	public void setSkipCreateTrackThumbNail(boolean skipCreateTrackThumbNail) {
		this.skipCreateTrackThumbNail = skipCreateTrackThumbNail;
	}

	/**
	 * @return
	 */
	public String getTargetDirectory() {
		return targetDirectory;
	}

	/**
	 * @param targetDirectory
	 */
	public void setTargetDirectory(String targetDirectory) {
		this.targetDirectory = targetDirectory;
	}

	/**
	 * @return
	 */
	public String getTargetFileExtension() {
		return targetFileExtension;
	}

	/**
	 * @param targetFileExtension
	 */
	public void setTargetFileExtension(String targetFileExtension) {
		this.targetFileExtension = targetFileExtension;
	}

}
