/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _XID_CONTROLLER_H
#define _XID_CONTROLLER_H

#ifdef __cplusplus
extern "C"
{
#endif
	// Since I'm set on using C++, I think it's proper to include this headers via C style
	#include "wdm.h"
#ifdef __cplusplus
}
#endif

#include "xidtypes.h"
#include "xidconfig.h"

#define XINPUT_GAMEPAD_DPAD_UP          0x00000001
#define XINPUT_GAMEPAD_DPAD_DOWN        0x00000002
#define XINPUT_GAMEPAD_DPAD_LEFT        0x00000004
#define XINPUT_GAMEPAD_DPAD_RIGHT       0x00000008
#define XINPUT_GAMEPAD_START            0x00000010
#define XINPUT_GAMEPAD_BACK             0x00000020
#define XINPUT_GAMEPAD_LEFT_THUMB       0x00000040
#define XINPUT_GAMEPAD_RIGHT_THUMB      0x00000080
#define XINPUT_GAMEPAD_A                0
#define XINPUT_GAMEPAD_B                1
#define XINPUT_GAMEPAD_X                2
#define XINPUT_GAMEPAD_Y                3
#define XINPUT_GAMEPAD_BLACK            4
#define XINPUT_GAMEPAD_WHITE            5
#define XINPUT_GAMEPAD_LEFT_TRIGGER     6
#define XINPUT_GAMEPAD_RIGHT_TRIGGER    7
#define XINPUT_GAMEPAD_MAX_CROSSTALK	30
#define XINPUT_NUM_ANALOG_BUTTONS       8

struct XINPUT_DBUTTONS
{
    BYTE  U   : 1;
    BYTE  D   : 1;
    BYTE  L   : 1;
    BYTE  R   : 1;
    BYTE  S   : 1;
    BYTE  B   : 1;
    BYTE  LT  : 1;
    BYTE  RT  : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
    BYTE      : 1;
};

struct XINPUT_REPORT
{
    BYTE       bReportId;                                      // 0=default input report
    BYTE       bLength;                                        // size of this report
    union                                                      // bit array of 16 digital buttons
    {
        USHORT           bmButtons;                            // bit array of 16 digital buttons
        XINPUT_DBUTTONS  bmButtonsBits;
    };
    BYTE       analogButtons[XINPUT_NUM_ANALOG_BUTTONS];       // array of 8 analog buttons
    SHORT      sThumbLX;                                       // X position of first thumbstick
    SHORT      sThumbLY;                                       // Y position of first thumbstick
    SHORT      sThumbRX;                                       // X position of second thumbstick
    SHORT      sThumbRY;                                       // Y position of second thumbstick
};

#define XIDFEATUREFLAG_INVERT 1

class XIDCONTROLLER
{
	private:
		XINPUT_REPORT internalReport;
	public:
		void UpdateInternalReport(void *, unsigned char);
		BYTE Button(const XIDFEATURE_BUTTON *);
		SHORT Axis(const XIDFEATURE_AXIS *);
		BYTE Hat(const XIDFEATURE_HAT *); // returns the single byte that respresents that hat switch
		bool Start();
		bool Back();
		bool LStick();
		bool RStick();
		bool DPadU();
		bool DPadUR();
		bool DPadR();
		bool DPadDR();
		bool DPadD();
		bool DPadDL();
		bool DPadL();
		bool DPadUL();
		BYTE A();
		BYTE B();
		BYTE X();
		BYTE Y();
		BYTE Black();
		BYTE White();
		BYTE LTrig();
		BYTE RTrig();
		SHORT LStickX();
		SHORT LStickY();
		SHORT RStickX();
		SHORT RStickY();	
};

#endif