/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "xidbytestream.h"

ByteStream::ByteStream(unsigned char *startPtr)
{
	setPointer(startPtr);
}
void ByteStream::setPointer(unsigned char *startPtr)
{
	internalPtr = startPtr;
	index = count = 0;
}

void ByteStream::next(const unsigned char value)
{
	if(internalPtr != NULL)
		internalPtr[index++] = value;
	count++;
}

ByteStream& operator <<(ByteStream &out, const unsigned char value)
{
	out.next(value);
	return out;
}

unsigned int ByteStream::counter()
{
	return count;
}