/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __XIDUSB_H__
#define __XIDUSB_H__

#ifdef __cplusplus
extern "C"
{
#endif
	#include "wdm.h"
	#include "hidport.h"
	#include "usb100.h"
	#include "usbioctl.h"
	#include "usbdi.h"
	#include "usbdlib.h"
#ifdef __cplusplus
}
#endif

#include "xid.h"

#define FreeIfAllocated(x) if( (x)!=NULL) { ExFreePool(x); (x) = NULL; }

#define TRANSFER_IN		1
#define TRANSFER_OUT	2

NTSTATUS CallUSBDI(IN PHID_DEVICE_EXTENSION, IN PVOID, IN ULONG IoControlCode=IOCTL_INTERNAL_USB_SUBMIT_URB, IN ULONG Arg2=0);
NTSTATUS UsbGetPortStatus( IN PHID_DEVICE_EXTENSION, OUT ULONG&);
NTSTATUS UsbResetPort( IN PHID_DEVICE_EXTENSION);
NTSTATUS UsbResetDevice( IN PHID_DEVICE_EXTENSION);
NTSTATUS UsbGetUsbInfo( IN PHID_DEVICE_EXTENSION);
NTSTATUS UsbGetDeviceDescriptor( IN PHID_DEVICE_EXTENSION, OUT PUSB_DEVICE_DESCRIPTOR&, OUT ULONG& );
NTSTATUS UsbGetConfigurationDescriptors( IN PHID_DEVICE_EXTENSION, OUT PUSB_CONFIGURATION_DESCRIPTOR&, IN UCHAR, OUT ULONG&);
NTSTATUS UsbSelectConfiguration(IN PHID_DEVICE_EXTENSION);
NTSTATUS UsbDeselectConfiguration(IN PHID_DEVICE_EXTENSION );
NTSTATUS UsbDoInterruptTransfer( IN PHID_DEVICE_EXTENSION, IN PVOID, ULONG&, ULONG);

#endif