// ******************************************************************
// * 
// * proj : Sample
// *
// * desc : Sample for Open Source XBox Development Kit
// *
// * file : main.cpp
// *
// * note : Tiny OpenXDK Animation
// *
// ******************************************************************
#include <openxdk.h>
#include <stdlib.h>
#include <stdio.h>

// ******************************************************************
// * WinMainCRTStartup (Entry Point)
// ******************************************************************
void WinMainCRTStartup()
{
    char  buffer[1024];
    float last = (float)KeTickCount;
    int   fps  = 0;

    RtlZeroMemory(buffer, 1024);

    // Currently, this is the only mode supported by xhal.lib
	InitMode( MODE_320x240x32 );

    // Animate up and down
    int y=25, ys=1;

    // XBox software does not typically ever return from its entry point
	while(true)
    {
        
		WaitVBlank();				// Wait for Vertical Blank
        Flip();						// Flip
		Cls();						// Clear screen

        fps  = (int)(1.0f/(((float)KeTickCount - last) / 1000.0f));
        last = (float)KeTickCount;
        
		// Print to screen
 	    sprintf(buffer,"OpenXDK Sample: %d fps", fps);
		Print(50,y, buffer);
		
		// Move text up and down
        y+=ys;
        if(y > 175 || y < 25)
            ys = -ys;
	}

    /*
    xvga_set256x240();

    uint32 *buffer = (uint32*)0x8003d040;

    int PITCH_HACK=8;
    int count = 0;

    while(true)
    {
        // wait for vblank
        while(*(uint08*)0xFD6013DA & 0x08);

        int v=0;
        bool a=true;
        for(int y=0;y<240;y++)
        {
            bool c=true;
            for(int x=0;x<512;x++)
            {
                if(x%32 == 0)
                    c = !c;

                if(c)
                    buffer[v++] = a?0xFF:0x00;
                else
                    buffer[v++] = a?0xFF0000:0xFF00;
            }

            v+=64;
            
            a = !a;
        }

        // wait for end of vblank
        while(!(*(uint08*)0xFD6013DA & 0x08));

        count++;

        if(count == 60)
        {
            PITCH_HACK += 8;
            count = 0;
        }
    }
*/
    return;
}