#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <hal/xbox.h>
#include <openxdk/debug.h>

#define FILENAME "TEST.$$$"

void XBoxStartup()
{
	char buffer[60];

	sprintf(buffer, "Time 1=%d\n", times(NULL));
	debugPrint(buffer);
	XSleep(5000);
	sprintf(buffer, "Time 2=%d\n", times(NULL));
	debugPrint(buffer);
	XSleep(5000);
	sprintf(buffer, "Time 3=%d\n", times(NULL));
	debugPrint(buffer);

	debugPrint("PID="); debugPrintNum(getpid()); debugPrint("\n");

	struct stat statbuf;
	if (!stat("c:/blah.txt", &statbuf))
	{	
		if (statbuf.st_mode & S_IFCHR)
		   debugPrint("Handle refers to a device.\n");
		if (statbuf.st_mode & S_IFREG)
		   debugPrint("Handle refers to an ordinary file.\n");
		if (statbuf.st_mode & S_IFDIR)
		   debugPrint("Handle refers to a directory.\n");
		if (statbuf.st_mode & S_IREAD)
		   debugPrint("User has read permission on file.\n");
		if (statbuf.st_mode & S_IWRITE)
		   debugPrint("User has write permission on file.\n");
	
		sprintf(buffer, "Size of file in bytes: %ld\n", statbuf.st_size);
		debugPrint(buffer);
		sprintf(buffer, "Time file last opened: %s\n", ctime(&statbuf.st_ctime));
		debugPrint(buffer);
		sprintf(buffer, "Time file last accessed: %s\n", ctime(&statbuf.st_atime));
		debugPrint(buffer);
		sprintf(buffer, "Time file last modified: %s\n", ctime(&statbuf.st_mtime));
		debugPrint(buffer);
	}

	freopen ("c:/stdout.txt", "w", stdout);
	printf ("This sentence is redirected to a file.");
	fclose (stdout);	
  
	XSleep(5000);
	XReboot();
}
