#include <stdlib.h>
#include <stdio.h>
#include <hal/pad.h>
#include <hal/xbox.h>
#include <openxdk/debug.h>

void dumpPad(XPadState pad)
{
	char buffer[80];
	sprintf(buffer, " 0x%02X", pad.pad);
	debugPrint(buffer);
//	sprintf(buffer, "Keys A=0x%02X B=0x%02X X=0x%02X Y=0x%02X Black=0x%02X White=0x%02X\n", pad.keys[0], pad.keys[1], pad.keys[2], pad.keys[3], pad.keys[4], pad.keys[5]);
//	debugPrint(buffer);
//	sprintf(buffer, "Trigger Left=0x%02X Right=0x%02X\n", pad.trig_left, pad.trig_right);
//	debugPrint(buffer);
//	sprintf(buffer, "Left Stick x=0x%02X y=0x%02X\n", pad.stick_left_x, pad.stick_left_y);
//	debugPrint(buffer);
//	sprintf(buffer, "Right Stick x=0x%02X y=0x%02X\n", pad.stick_right_x, pad.stick_right_y);
//	debugPrint(buffer);
//	debugPrint("\n");
}

void XBoxStartup()
{
	XUSBControl xcontrol;
	XPadState pad;

debugPrint("Initialising... ");
	XInitInput(&xcontrol);
debugPrint("done!\n");
	
	while(1)
  {
		// Get our gamepad information
		XGetPadInput(&pad, &xcontrol, 0);
		dumpPad(pad);
		// if we press the A key, we'll rumble and exit
		if(pad.keys[0] > 0xD0)
		{
			// dodgy rumble code
			//XSetPadInput(&pad, &xcontrol, 0);
			break;
		}
	}
	XReleaseInput(&xcontrol);
	XSleep(1000);
}

