;==========================================================================
; Projet    : SimpleXExt
;==========================================================================
.586p
.model flat, stdcall
option casemap:none ; case sensitive

;==========================================================================
; Creation : 04/03/2001
; Author   : Maurice Montgenie
; Credits  : Michael Dunn (who first coded it in ATL)
;
;--- Description ----------------------------------------------------------
; A SimpleX context menu extension.
;==========================================================================

; ============================== Includes =================================
	include \MASM32\include\windows.inc
	
	include \MASM32\include\oleaut32.inc
	include \MASM32\include\user32.inc
	include \MASM32\include\kernel32.inc
	include \MASM32\include\ole32.inc
	include \MASM32\include\advapi32.inc
	
	;colib
	include \masm32\COM\include\oaidl.inc
	include \masm32\COM\include\colib.inc
	
	include ShellExt.inc
	
	include \MASM32\include\masm32.inc
	  
	;Interface definition
	include ISimpleXExt.inc
  
; ============================== Librairies ===============================
	includelib \masm32\COM\colib\colib.lib
	
	includelib \MASM32\lib\masm32.lib
	
	includelib \MASM32\lib\user32.lib
	includelib \MASM32\lib\kernel32.lib
	includelib \MASM32\lib\advapi32.lib
	includelib \MASM32\lib\ole32.lib
	includelib \MASM32\lib\oleaut32.lib
  
  PUBLIC ClassMap

; ============================== Macros ===================================
	MAKE_HRESULT MACRO sev,fac,code
		mov ecx, sev
		shl ecx, 31
		mov eax, fac
		shl eax, 16
		or eax, ecx
		or eax, code
	ENDM
  
	LOWORD	MACRO 	bigword	;; Retrieves the low word from double word argument
		mov	eax,bigword
		and	eax,0FFFFh	;; Set to low word 
	ENDM
  
	HIWORD	MACRO   bigword	;; Retrieves the high word from double word argument
		mov	eax,bigword
		shr	eax,16		;; Shift 16 for high word to set to high word				
	ENDM
  
	return MACRO arg
		mov eax, arg
		ret
	ENDM
  
	dsText MACRO Name, Text:VARARG
		.const
			Name db Text,0
		.code
	ENDM

; ============================== Protos ===================================
	lstrcpynW			PROTO :DWORD, :DWORD, :DWORD
	DeleteRegistryKey	PROTO :DWORD, :DWORD
	IsXboxIso			PROTO :DWORD
	IsDirectory			PROTO :DWORD
; ============================== Datas ====================================
IDB_APPICON		equ	302
ID_ISOFILE		equ 0
ID_DIRECTORY	equ 1

ID_ContextMenu	equ 0
ID_DragDrop		equ 1

.const
	szExtractXIso		db "Extract XISO ....",0
	szExtractHere		db "Extract XISO here",0
	szExtractIsoFormat	db "Extract to "
	szExtractIsoString	db "%s\",0
	szDDExtractIsoFormat	db "Extract to "
	szDDExtractIsoString	db "%s\%s\",0
	szCreateXIso		db "Make XISO ...",0
	szCreateIsoFormat	db "Make "
	szCreateIsoString	db "%s.iso",0
	szDDCreateIsoFormat	db "Make "
	szDDCreateIsoString db "%s\%s.iso",0
	
	szFormatCommandLine db '"%s\SimpleX.exe" "%s" "%s"',0
	szFormatExtendCommand db '"%s\SimpleX.exe" "%s"',0
	
	szExtractHelp	db "Extract folders and files inside this Xbox iso. (Written by XoXoX)",0
	szCreateHelp	db "Make Xbox iso from this folder. (Written by XoXoX)",0
	
	szMsgFmt			db "The selected file was: %s",0
  	szAppName			db "SimpleX ISO",0
  	szCanNotRunSimpleX	db "Can't run SimpleX.exe",13,10,"It may be not in the same folder of SimpleXExt.dll",0
  	szXboxMediaString	db "MICROSOFT*XBOX*MEDIA",0
.data
	;Describe the classes inside the DLL
	ClassMap    ClassItem { pCLSID_SimpleXExt, DISPINTERFACE + SUPPLY_TYPE_INFO, \
	     OFFSET SimpleXExtTypeLibInfo, OFFSET SimpleXExtIMap,     \
	     NULL, NULL, NULL, SIZEOF SimpleXExtObjData0 }
	END_CLASS_MAP
	
	;Describe the object's interfaces
	SimpleXExtIMap  InterfaceItem { pIID_ISimpleXExt,	OFFSET vtableISimpleXExt }
	                InterfaceItem { pIID_IShellExtInit,	OFFSET vtableIShellExtInit }
	                InterfaceItem { pIID_IContextMenu,	OFFSET vtableIContextMenu }
	END_INTERFACE_MAP
	
	;Describe the type librarie
	SimpleXExtTypeLibInfo   TypeLibInfo     { pLIBID_SimpleXExtLib, 1, 0 }     
	
	;Describe the object itself (takes 2 steps)
	;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	;Step 1: private data
	SimpleXExtObjData   STRUCT
		pFileName		DWORD 0
		pExtension		DWORD 0
		dwObjectType	DWORD 0
		dwActionType	DWORD 0
		szFile			CHAR MAX_PATH DUP(0)
		szFolder		CHAR MAX_PATH DUP (0)
	SimpleXExtObjData   ENDS
	
	;Step 2: object definition
	SimpleXExtObjData0  SimpleXExtObjData  { } ; custom object data
	
	;The vtables
	vtableISimpleXExt	ISimpleXExt		{ pvtIDispatch }
	vtableIShellExtInit IShellExtInit	{ pvtIShellExtInit }
	vtableIContextMenu	IContextMenu	{ pvtIContextMenu }
	
	;GUIDs
	DeclareGuid IID_ISimpleXExt
	DeclareGuid CLSID_SimpleXExt
	DeclareGuid LIBID_SimpleXExtLib
	
	DeclareGuid IID_IShellExtInit
	DeclareGuid IID_IContextMenu

	hDllIcon	DWORD 0
; ============================== Code =====================================
.code
;==========================================================================
; Initializes the context menu extension.
;--------------------------------------------------------------------------
	szRegFormat db "Class: %s - Subkeys: %d - Values: %d",0
	
Initialize proc uses edi esi ebx this_:DWORD, pidlFolder:DWORD, pDataObj:DWORD, hProgID:DWORD
	LOCAL fmt:FORMATETC
	LOCAL stg:STGMEDIUM
	LOCAL hResult:DWORD
	LOCAL hRegKey:DWORD
	LOCAL dwRegType:DWORD
	LOCAL dwActionType:DWORD
	LOCAL dwObjectType:DWORD
	LOCAL dwClassLen:DWORD
	LOCAL szClass[512]:CHAR
	
	pObjectData this_, esi
	lea edi,(SimpleXExtObjData PTR [esi]).szFolder
	mov ecx,pidlFolder
	.IF ecx ; Drop Action
		invoke SHGetPathFromIDList, ecx, edi
		.IF !eax
			mov hResult, E_INVALIDARG
			jmp lbl_InitExit			
		.ENDIF
		invoke lstrlen,edi
		lea edx,[edi+eax-1]
		.IF BYTE PTR [edx]=='\'
			mov BYTE PTR [edx],0
		.ENDIF
		mov dwActionType,ID_DragDrop
	.ELSE
		mov DWORD PTR [edi],0
		mov dwActionType,ID_ContextMenu
	.ENDIF
	;Initialization of fmt
	mov fmt.cfFormat, CF_HDROP
	mov fmt.ptd, NULL
	mov fmt.dwAspect, DVASPECT_CONTENT
	mov fmt.lindex, -1
	mov fmt.tymed, TYMED_HGLOBAL 
	
	;Initialization of stg
	mov stg.tymed, TYMED_HGLOBAL
	
	;Look for CF_HDROP data in the data object.
	coinvoke pDataObj, IDataObject, GetData, ADDR fmt, ADDR stg
	.IF_FAILED
		;Nope! return an "invalid argument" error back to Explorer.
		mov hResult, E_INVALIDARG
		jmp lbl_InitExit
	.ENDIF
	
	.IF stg.hGlobal == NULL
		mov hResult, E_INVALIDARG
		jmp lbl_InitExit
	.ENDIF
	
	;Sanity check  make sure there is at least one filename.
	invoke DragQueryFile, stg.hGlobal, 0FFFFFFFFh, NULL, 0
	.IF !eax
		invoke ReleaseStgMedium, ADDR stg
		mov hResult, E_INVALIDARG
		jmp lbl_InitExit
	.ENDIF
	
	;Get the name of the first file and store it in our member variable szFile.
	pObjectData this_, ecx  ; cast this_ to object data
	lea edi, (SimpleXExtObjData PTR [ecx]).szFile
	
	invoke DragQueryFile, stg.hGlobal, 0, edi, MAX_PATH
	.IF !eax
		mov hResult, E_INVALIDARG
		jmp lbl_InitExit
	.ENDIF
	invoke ReleaseStgMedium, ADDR stg

	;Load Icon
	.IF hDllIcon==0
		invoke LoadBitmap,g_hModule,IDB_APPICON
		mov hDllIcon,eax
	.ENDIF
	
	mov ecx,dwActionType
	.IF ecx==ID_DragDrop
		invoke lstrlen,edi
		mov ebx,eax
		mov edx,DWORD PTR [edi+eax-4]
		.IF edx=="osi."
			invoke IsXboxIso,edi
			.IF eax
				mov dwObjectType,ID_ISOFILE
				jmp lbl_GetMoreInfo
			.ENDIF
		.ENDIF
		invoke IsDirectory,edi
		.IF eax
			mov dwObjectType,ID_DIRECTORY
			jmp lbl_GetMoreInfo
		.ENDIF		
	.ELSE
		mov ebx,hProgID
		.IF (ebx!=0)
			lea ecx,dwClassLen
			mov DWORD PTR [ecx],512
			lea esi,szClass
			invoke RegQueryValueEx,ebx,NULL,NULL,ADDR dwRegType,esi, ecx
			.IF eax==ERROR_SUCCESS
				mov eax,DWORD PTR [esi]
				.IF eax==' OSI'
					invoke IsXboxIso,edi
					.IF eax
						mov dwObjectType,ID_ISOFILE
						jmp lbl_GetMoreInfo			
					.ENDIF
				.ELSEIF eax=='eliF'
					mov dwObjectType,ID_DIRECTORY
					jmp lbl_GetMoreInfo
				.ENDIF
			.ENDIF
		.ENDIF
	.ENDIF
	mov hResult, E_INVALIDARG
	jmp lbl_InitExit				



	;Get Object Name from Path
lbl_GetMoreInfo:

	pObjectData this_, esi
	assume esi: PTR SimpleXExtObjData
	mov eax,dwObjectType
	mov [esi].dwObjectType,eax
	mov eax,dwActionType
	mov [esi].dwActionType,eax
	invoke lstrlen,edi
	.IF eax>0
		mov ecx,[esi].dwObjectType
		.IF ecx==ID_ISOFILE
			lea edx,[edi+eax-4]
			mov [esi].pExtension,edx  ;points to the dot
		.ELSE
			lea edx,[edi+eax]
			mov [esi].pExtension,edx  ;points to the end of the name
			dec edx
		.ENDIF
			
		.WHILE BYTE PTR [edx]!='\'
			dec edx
		.ENDW
		inc edx
		mov [esi].pFileName,edx ;points to filename
	.ENDIF
	assume esi:NOTHING

	mov hResult, S_OK
lbl_InitExit:
	return hResult
Initialize endp

;==========================================================================
; Adds commands to a context menu.
;--------------------------------------------------------------------------

QueryContextMenu proc uses edi esi this_:DWORD, hmenu:DWORD, uMenuIndex:DWORD,\
  uidFirstCmd:DWORD, uidLastCmd:DWORD, uFlags:DWORD
	LOCAL hResult:DWORD
	LOCAL uCmdID:DWORD
	LOCAL numItems:DWORD
	LOCAL szTemp[MAX_PATH]:CHAR
	
	mov eax,uidFirstCmd
	mov uCmdID,eax
  	;If the flags include CMF_DEFAULTONLY then we shouldn't do anything.
	.IF uFlags & CMF_DEFAULTONLY
		MAKE_HRESULT SEVERITY_SUCCESS, FACILITY_NULL, 0
		mov hResult, eax
	.ENDIF
	
	mov numItems,0
	pObjectData this_, esi
	assume esi:PTR SimpleXExtObjData
	mov eax,[esi].dwActionType
	.IF eax==ID_ContextMenu
		mov eax,[esi].dwObjectType
		.IF eax==ID_ISOFILE
			mov edx,OFFSET szExtractXIso
		.ELSE
			mov edx,OFFSET szCreateXIso
		.ENDIF
		invoke InsertMenu, hmenu, uMenuIndex, MF_BYPOSITION, uCmdID,edx
		.IF hDllIcon!=0
       		invoke SetMenuItemBitmaps, hmenu, uMenuIndex, MF_BYPOSITION, hDllIcon, NULL
		.ENDIF  
		inc uCmdID
		inc uMenuIndex
		inc numItems
	.ENDIF

	mov eax,[esi].dwObjectType
	.IF eax==ID_ISOFILE
		invoke InsertMenu, hmenu, uMenuIndex, MF_BYPOSITION, uCmdID, OFFSET szExtractHere
		.IF hDllIcon!=0
        	invoke SetMenuItemBitmaps, hmenu, uMenuIndex, MF_BYPOSITION, hDllIcon, NULL
		.ENDIF  
		inc uCmdID
		inc uMenuIndex
		inc numItems
	.ENDIF

	lea edi,szTemp	
	mov ecx,[esi].dwActionType
	mov eax,[esi].dwObjectType
	.IF eax==ID_DIRECTORY
		.IF ecx==ID_ContextMenu
			invoke wsprintf,edi,ADDR szCreateIsoFormat,[esi].pFileName
		.ELSE
			invoke wsprintf,edi,ADDR szDDCreateIsoFormat,ADDR [esi].szFolder,[esi].pFileName
			lea edx,[edi+5]
			invoke lstrcpy,ADDR [esi].szFolder,edx
		.ENDIF
	.ELSE
		mov edx,[esi].pExtension
		mov BYTE PTR [edx],0	; separate extension from filename by replacing dot by zero
		push edx
		.IF ecx==ID_ContextMenu		
			invoke wsprintf,edi, ADDR szExtractIsoFormat,[esi].pFileName
		.ELSE
			invoke wsprintf,edi, ADDR szDDExtractIsoFormat,ADDR [esi].szFolder,[esi].pFileName
			
		.ENDIF
		pop edx
		mov BYTE PTR [edx],'.' ;	put the dot back
	.ENDIF
	assume esi:NOTHING
	
	invoke InsertMenu, hmenu, uMenuIndex, MF_BYPOSITION, uCmdID, edi
	.IF hDllIcon!=0
        invoke SetMenuItemBitmaps, hmenu, uMenuIndex, MF_BYPOSITION, hDllIcon, NULL
	.ENDIF
	inc uMenuIndex
	inc numItems
	
	MAKE_HRESULT SEVERITY_SUCCESS, FACILITY_NULL, numItems
	mov hResult, eax
  
	return hResult
QueryContextMenu endp

;==========================================================================
; Retrieves a context menu command's language-independent name 
; or its Help text.
;--------------------------------------------------------------------------
GetCommandString proc uses esi this_:DWORD, idCmd:DWORD, uFlags:DWORD,\
  pwReserved:DWORD, pszName:DWORD, cchMax:DWORD

	LOCAL hResult
	LOCAL wcszHelpString[MAX_PATH]:WCHAR
	
	;Check idCmd
	.IF ( idCmd >= 3 )
		mov hResult, E_INVALIDARG
		jmp @F
	.ENDIF
	
	;If Explorer is asking for a help string, copy our string into the supplied buffer.
	pObjectData this_, ecx
	mov eax,(SimpleXExtObjData PTR [ecx]).dwObjectType
	.IF eax==ID_DIRECTORY
		mov edx,OFFSET szCreateHelp
		mov eax,SIZEOF szCreateHelp
	.ELSE
		mov edx,OFFSET szExtractHelp
		mov eax,SIZEOF szExtractHelp
	.ENDIF
	
	.IF uFlags == GCS_HELPTEXTA
		invoke lstrcpyn, pszName,edx, cchMax
	.ELSEIF uFlags == GCS_HELPTEXTW
		lea ecx, wcszHelpString
		invoke WideCharToMultiByte,CP_ACP,0,edx,-1,ecx,eax,NULL,NULL
		mov ecx,eax
		invoke lstrcpynW, pszName, ecx, cchMax
	.ENDIF
	
	mov hResult, S_OK
	
	@@:
	return hResult
GetCommandString endp
    
;==========================================================================
; Carries out the command associated with a context menu item.
;--------------------------------------------------------------------------
	
InvokeCommand proc uses edi esi ebx this_:DWORD, pCmdInfo:DWORD
	LOCAL hResult:DWORD
	LOCAL startInfo:STARTUPINFO
	LOCAL processInfo: PROCESS_INFORMATION 
	LOCAL szModulePath[MAX_PATH]:CHAR
	LOCAL szSource[MAX_PATH]:CHAR
	LOCAL szCommandLine[MAX_PATH]:CHAR
	
	;If lpVerb really points to a string, ignore this function call and bail out.
	mov ecx, pCmdInfo
	mov ebx, (CMINVOKECOMMANDINFO PTR[ecx]).lpVerb
	push ebx
	HIWORD ebx
	.IF eax
		mov hResult, E_INVALIDARG
		jmp @F
	.ENDIF
	pObjectData this_, esi  ; cast this_ to object data
	assume esi:PTR SimpleXExtObjData
	invoke lstrcpy,ADDR szSource,ADDR [esi].szFile	
	;Get the command index - the only valid one is 0.
	pop ebx
	LOWORD ebx
	
	.IF eax<3
		push eax
		;---------------- get path
			lea edi,szModulePath
			invoke GetModuleFileName,g_hModule,edi,MAX_PATH
			invoke lstrlen,edi
			dec eax
			.WHILE BYTE PTR [edi+eax]!='\'
				dec eax
			.ENDW
			mov BYTE PTR [edi+eax],0
		;------------------------
		pop eax		
		.IF (eax==0) && ([esi].dwActionType!=ID_DragDrop)
			invoke wsprintf,ADDR szCommandLine,ADDR szFormatExtendCommand,ADDR szModulePath,ADDR szSource
		.ELSE
			mov ecx,[esi].dwActionType
			.IF ecx==ID_DragDrop
				lea ebx,[esi].szFolder
				.IF eax==1
					.IF [esi].dwObjectType==ID_ISOFILE
						mov eax,[esi].pExtension
						mov BYTE PTR [eax],0
						mov ecx,[esi].pFileName
						dec ecx
						invoke lstrcat,ebx,ecx
					.ENDIF
				.ENDIF
				
			.ELSE
				.IF eax==1	;Extract Here
					.IF [esi].dwObjectType==ID_DIRECTORY
						mov eax, [esi].pExtension
						mov DWORD PTR [eax],'osi.'
						lea eax,[eax+4]
					.ELSE
						mov eax, [esi].pFileName
						dec eax
					.ENDIF
				.ELSE		;Extract To
					mov eax, [esi].pExtension
				.ENDIF
				mov BYTE PTR [eax],0
				lea ebx,[esi].szFile
			.ENDIF
			invoke wsprintf,ADDR szCommandLine,ADDR szFormatCommandLine,ADDR szModulePath,ADDR szSource,ebx
		.ENDIF
		assume esi:NOTHING
		
		;mov ecx, pCmdInfo
		;mov ecx, (CMINVOKECOMMANDINFO PTR [ecx]).hwnd
		;invoke MessageBox, ecx, ADDR szCommandLine, OFFSET szAppName, MB_ICONINFORMATION
		
		invoke GetStartupInfo,ADDR startInfo
		invoke CreateProcess,NULL,ADDR szCommandLine,NULL,NULL,FALSE,\
			NORMAL_PRIORITY_CLASS,NULL,NULL,ADDR startInfo,ADDR processInfo		
		.IF eax==0
			mov ecx, pCmdInfo
			mov ecx, (CMINVOKECOMMANDINFO PTR [ecx]).hwnd
			invoke MessageBox,ecx,ADDR szCanNotRunSimpleX,ADDR szAppName,MB_OK + MB_ICONSTOP
		.ENDIF
		mov hResult, S_OK
	.ELSE
		mov hResult, E_INVALIDARG
	.ENDIF
	
	@@:        
	return hResult
InvokeCommand endp

;==========================================================================
DllRegisterServer PROC PUBLIC            
;-------------------------------------------------------------------------------
; COM server dll main export
;   Registers a component to the registry   
;
; EXAMPLE:
;   invoke DllRegisterServer
;
; Uses: eax, ecx, edx
;
;-------------------------------------------------------------------------------
    LOCAL rCount:DWORD,         hres:DWORD;,         pResEnd:DWORD
    LOCAL psCount:DWORD,        psBuf:DWORD,        pwsBuf:DWORD
    LOCAL szTypeLib[20]:BYTE,   pti:DWORD
    LOCAL ovi:OSVERSIONINFO
    LOCAL NewKey, Disp:DWORD

    ; install the registry script
    invoke Register, TRUE
    ; make some strings
    invoke HeapAlloc, g_hHeap, NULL, ( MAX_PATH * 3 + 10)
    mov psBuf, eax
    add eax, MAX_PATH * 2
    mov pwsBuf, eax
    add eax, 10
    mov psCount, eax
    mov rCount, 1           ; init the resource number to #1
    invoke LoadString, g_hModule, IDS_TypeLib, ADDR szTypeLib, 20
NextTypeLib:
    ; loop to find the resource
    invoke FindResource,g_hModule, rCount, ADDR szTypeLib
    .IF !eax
        jmp @@return
    .ENDIF
    mov hres, eax
    invoke LoadResource, g_hModule, hres
    invoke LockResource, eax
    mov hres, eax
    mov eax, [eax]      ; get 1st 4 characters of this resource
    cmp eax,5446534Dh   ; belt-and-suspenders check to assure is TypeLib res
    jne @@return ; 5446534DH = "TFSM", or "MSFT backwards, check for typelib resource
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    mov eax, psCount
    mov WORD PTR [eax], 005CH       ; "\", 0 string
    invoke lstrcat, psBuf, psCount  ; cat "\" onto FileName
    invoke dwtoa, rCount, psCount     
    invoke lstrcat, psBuf, psCount  ; cat "\####" onto FileName, where ####
                                    ;  is the resource number in string form
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    .IF !eax
        mov eax, S_FALSE
        jmp @@return
    .ENDIF
    lea eax, pti
    invoke LoadTypeLib, pwsBuf, eax
    .IF (eax != ERROR_SUCCESS)
        mov eax, S_FALSE
        jmp @@return
    .ENDIF
    ; and register the type lib
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    invoke RegisterTypeLib, pti, pwsBuf, NULL
    .IF (eax != ERROR_SUCCESS)
        mov eax, S_FALSE
        jmp @@return
    .ELSE
        ; release the type info pointer we got
        mov eax, pti
        mov eax, [eax]
        coinvoke pti, IUnknown, Release
    .ENDIF
    inc rCount
    jmp NextTypeLib
@@return:
	; clean up our buffers
	invoke HeapFree, g_hHeap, NULL, psBuf    
	
	;Special Registration of the shell extension for NT users
	;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	dsText szShellText,"SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved"
	dsText szCLSID,"{056D080D-DFCC-41D4-A6F1-81089A7F023E}"
	dsText szNameOfExt,"SimpleX Shell Extension in Asm"
	
	mov ovi.dwOSVersionInfoSize, sizeof ovi
	invoke GetVersionEx, ADDR ovi
	
	.IF ovi.dwPlatformId==VER_PLATFORM_WIN32_NT
		invoke RegCreateKeyEx, HKEY_LOCAL_MACHINE, OFFSET szShellText, NULL, NULL,\ 
			REG_OPTION_NON_VOLATILE, KEY_READ or KEY_WRITE, NULL,\
			ADDR NewKey, ADDR Disp
	
		invoke RegSetValueEx, NewKey, OFFSET szCLSID,\ 
			NULL, REG_SZ, OFFSET szNameOfExt, sizeof szNameOfExt     
	
		invoke RegCloseKey, NewKey
	.ENDIF
	
	xor eax, eax    ;    mov eax, S_OK
	ret
DllRegisterServer ENDP

;==========================================================================
DllUnregisterServer PROC PUBLIC             
;-------------------------------------------------------------------------------
; COM server dll main export
;   Unregisters a component from the registry
;   
; EXAMPLE:
;   invoke DllUnregisterServer
;
; Uses: eax, ecx, edx
;
;-------------------------------------------------------------------------------
    LOCAL rCount:DWORD,         hres:DWORD;,         pResEnd:DWORD
    LOCAL psCount:DWORD,        psBuf:DWORD,        pwsBuf:DWORD
    LOCAL szTypeLib[20]:BYTE,   pti:DWORD,          pTLibAttr:DWORD 
    LOCAL m_MajorVer:DWORD,     m_MinorVer:DWORD 
    LOCAL m_lcid:DWORD,         m_syskind:DWORD
    LOCAL ovi:OSVERSIONINFO
    LOCAL NewKey:DWORD

    invoke Register, FALSE
    ; make some strings
    invoke HeapAlloc, g_hHeap, NULL, ( MAX_PATH * 3 + 10)
    mov psBuf, eax
    add eax, MAX_PATH * 2
    mov pwsBuf, eax
    add eax, 10
    mov psCount, eax
    mov rCount, 1           ; init the resource number to #1
    invoke LoadString, g_hModule, IDS_TypeLib, ADDR szTypeLib, 20
NextTypeLib:
    ; loop to find the resource
    invoke FindResource,g_hModule, rCount, ADDR szTypeLib
    .IF !eax
        jmp @@return
    .ENDIF
    mov hres, eax
    invoke LoadResource, g_hModule, hres
    invoke LockResource, eax
    mov hres, eax
    mov eax, [eax]               ; get 1st 4 characters of this resource
    cmp eax,5446534Dh            ; ew-check to assure is TypeLib resource
    jne @@return                 ; 5446534DH = "TFSM", or "MSFT" backwards
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    mov eax, psCount
    mov ecx, 0000005CH
    mov [eax], ecx
    invoke lstrcat, psBuf, psCount  ; cat "\" onto FileName
    invoke dwtoa, rCount, psCount
    invoke lstrcat, psBuf, psCount  ; cat "\####" onto FileName, where ####
                                    ;  is the resource number in string form
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    .IF !eax
        mov eax, S_FALSE
        jmp @@return
    .ENDIF
    invoke LoadTypeLib, pwsBuf, ADDR pti
    .IF_FAILED
        mov eax, S_FALSE
        jmp @@return
    .ENDIF
    mov pTLibAttr, 0
    lea ecx, pTLibAttr
    coinvoke pti, ITypeLib, GetLibAttr, ecx
    .IF_FAILED
        coinvoke pti, ITypeLib, Release
        mov eax, S_FALSE
        jmp @@return
    .ENDIF
    mov ecx, pTLibAttr
    xor eax, eax
    mov ax, (TLIBATTR PTR [ecx]).wMajorVerNum
    mov m_MajorVer, eax
    mov ax, (TLIBATTR PTR [ecx]).wMinorVerNum 
    mov m_MinorVer, eax 
    mov eax, (TLIBATTR PTR [ecx]).lcid
    mov m_lcid, eax 
    mov eax, (TLIBATTR PTR [ecx]).syskind
    mov m_syskind, eax
    mov ecx, pTLibAttr
    invoke UnRegisterTypeLib, ecx, m_MajorVer, m_MinorVer, m_lcid, m_syskind
    coinvoke pti, ITypeLib, ReleaseTLibAttr, pTLibAttr
    coinvoke pti, IUnknown, Release
    ; now try for the next typelib
    inc rCount
    jmp NextTypeLib
    ; clean up our buffers
    invoke HeapFree, g_hHeap, NULL, psBuf   
@@return:     

    ;Special Cleanup for NT users of the shell extension
    ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  	mov ovi.dwOSVersionInfoSize, sizeof ovi
  	invoke GetVersionEx, ADDR ovi

    .IF ovi.dwPlatformId==VER_PLATFORM_WIN32_NT
      invoke RegOpenKeyEx, HKEY_LOCAL_MACHINE, OFFSET szShellText, NULL,\
        KEY_SET_VALUE, ADDR NewKey

      invoke RegDeleteValue, NewKey, OFFSET szCLSID
          
      invoke RegCloseKey, NewKey
    .ENDIF
	
	jmp @F
    	szXIsoContextExt 		db "iso_auto_file\ShellEx\ContextMenuHandlers",0
    	szDirectoryContextExt	db "Directory\ShellEx\ContextMenuHandlers",0
    	szDirectoryDragDropExt	db "Directory\ShellEx\DragDropHandlers",0
    	szDriveDragDropExt 		db "Drive\ShellEx\DragDropHandlers",0
    	szFolderDragDropExt 	db "Drive\ShellEx\DragDropHandlers",0
    	szSimpleXExtName		db "SimpleX",0
	@@:
    invoke DeleteRegistryKey, ADDR szXIsoContextExt, ADDR szSimpleXExtName
    invoke DeleteRegistryKey, ADDR szDirectoryContextExt, ADDR szSimpleXExtName
    invoke DeleteRegistryKey, ADDR szDirectoryDragDropExt, ADDR szSimpleXExtName
    invoke DeleteRegistryKey, ADDR szDriveDragDropExt, ADDR szSimpleXExtName
    invoke DeleteRegistryKey, ADDR szFolderDragDropExt, ADDR szSimpleXExtName

    
    xor eax, eax
    ret
DllUnregisterServer ENDP

;==========================================================================
DeleteRegistryKey proc lpPath:DWORD, lpName:DWORD
	LOCAL hKey:DWORD
    invoke RegOpenKeyEx,HKEY_CLASSES_ROOT,lpPath,0,KEY_ALL_ACCESS,ADDR hKey
    invoke RegDeleteKey,hKey,lpName
    invoke RegCloseKey,hKey
	ret
DeleteRegistryKey endp
;==========================================================================
IsXboxIso proc uses esi ebx lpFile:DWORD
	LOCAL dwReadBytes:DWORD
	LOCAL szTemp[64]:DWORD
	
	invoke CreateFile,lpFile,GENERIC_READ,FILE_SHARE_READ or FILE_SHARE_WRITE,\
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.IF eax!=INVALID_HANDLE_VALUE					
		mov ebx,eax
		lea esi,szTemp
		invoke SetFilePointer,ebx,10000h,0,FILE_BEGIN
		invoke ReadFile,ebx,esi,14h,ADDR dwReadBytes,NULL
		mov DWORD PTR [esi+14h],0
		invoke CloseHandle,ebx
		invoke lstrcmp,esi,ADDR szXboxMediaString
		.IF eax==0
			mov eax,TRUE
		.ELSE
			mov eax,FALSE
		.ENDIF
	.ELSE
		mov eax,FALSE		
	.ENDIF
	ret
IsXboxIso endp
;===============================================================
IsDirectory proc lpPath:DWORD
	LOCAL curFolder[MAX_PATH]:CHAR
	
	invoke GetCurrentDirectory,MAX_PATH, ADDR curFolder
	.IF eax!=0
		invoke SetCurrentDirectory,lpPath
		.IF eax!=0
			invoke SetCurrentDirectory,ADDR curFolder
			mov eax,TRUE
		.ENDIF
	.ENDIF
	ret
IsDirectory endp
end DllMain