/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectStringFixedLength;
import org.farng.mp3.object.ObjectStringNullTerminated;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyLINK
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyLINK object.
     */
    public FrameBodyLINK() {
        //        this.setObject("Frame Identifier", "");
        //        this.setObject("URL", "");
        //        this.setObject("ID and Additional Data", "");
    }

    /**
     * Creates a new FrameBodyLINK object.
     *
     * @param frameIdentifier DOCUMENT ME!
     * @param url DOCUMENT ME!
     * @param additionalData DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyLINK(String frameIdentifier, String url,
                         String additionalData, boolean is6ByteHeader) {
        this.setObject("Frame Identifier", frameIdentifier);
        this.setObject("URL", url);
        this.setObject("ID and Additional Data", additionalData);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyLINK object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyLINK(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getAdditionalData() {
        return (String) getObject("ID and Additional Data");
    }

    /**
     * DOCUMENT ME!
     *
     * @param additionalData DOCUMENT ME!
     */
    public void getAdditionalData(String additionalData) {
        setObject("ID and Additional Data", additionalData);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getFrameIdentifier() {
        return (String) getObject("Frame Identifier");
    }

    /**
     * DOCUMENT ME!
     *
     * @param frameIdentifier DOCUMENT ME!
     */
    public void getFrameIdentifier(String frameIdentifier) {
        setObject("Frame Identifier", frameIdentifier);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "LINK" + ((char) 0) + getFrameIdentifier() + ((char) 0) +
               getAdditionalData();
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectStringFixedLength("Frame Identifier", 4));
        objectList.add(new ObjectStringNullTerminated("URL"));
        objectList.add(new ObjectStringSizeTerminated("ID and Additional Data"));
    }
}