/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/17 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using System.Threading;
using Gtk;
using Gdk;
using Glade;
using RecursiveFileExplorer;
using Xbgm.Core;

	/// <summary>
	/// Description of Progress Upload dir Galde Dialog.	
	/// </summary>
	public class ProgressUploadDirGlade
	{
		public int Response;
		private Filethread file;
		private Thread progress_worker;
		private ThreadNotify main_notify;
		private long initTime;
		private DateTime DtStartNow;
	
		public ProgressUploadDirGlade(FileExplorer FileExplorer, Xbgm.Config config, int Index, string dest, string source) 
		{ 
			#if (DEBUG)
				Console.WriteLine("In ProgressUploadDirGlade::ProgressUploadDirGladeDialog");
			#endif
			CreateGui();
			//Console.WriteLine("Sending to [{0}] ", dest);
			//Init Filethread class
			file = new Filethread(FileExplorer, config, Index, dest, source);
			// Declare Event to update the GUI
			file.EventUpdated += new EventHandler (EventFileThread);
			// Init Time when updating GUI
			initTime = DateTime.Now.Ticks;
			DtStartNow = DateTime.Now;
		}
		
		[Glade.Widget] Gtk.Dialog 		dialog2;
		[Glade.Widget] Gtk.Button 		cancelbutton2;
		[Glade.Widget] Gtk.Label 		label21;
		[Glade.Widget] Gtk.Label 		label24;
		[Glade.Widget] Gtk.Label 		label27;
		[Glade.Widget] Gtk.Label 		label28;
		[Glade.Widget] Gtk.ProgressBar 	progressbar1;
		[Glade.Widget] Gtk.ProgressBar 	progressbar2;

		public void CreateGui() 
		{
		 try{
				Glade.XML gxml = new Glade.XML (null, "uploaddir.glade", "dialog2", null);
				dialog2 = (Gtk.Dialog) gxml["dialog2"];
				label21 = (Gtk.Label) gxml["label21"];
				label24 = (Gtk.Label) gxml["label24"];
				label27 = (Gtk.Label) gxml["label27"];
				label28 = (Gtk.Label) gxml["label28"];
				cancelbutton2 = (Gtk.Button) gxml["cancelbutton2"];
				progressbar1 = (Gtk.ProgressBar) gxml["progressbar1"];
				progressbar2 = (Gtk.ProgressBar) gxml["progressbar2"];
				
				gxml.Autoconnect (this);

				cancelbutton2.Clicked += new EventHandler (Dialog_Cancel);

			   	dialog2.Title = "Progress Upload Directory via Boost Mode";
			   	dialog2.Icon = new Pixbuf(null, "xbgmicon.png");
		   		label21.Text = "";
				label24.Text = "";
				label27.Text = "";
				label28.Text = "";
				progressbar1.Text = String.Format ("Preparing tranfert...");
				progressbar2.Text = String.Format ("Preparing tranfert...");
			}
			catch(Exception ex){
					Console.WriteLine("Error in ProgressUploadDirGlade::CreateGui" + ex.Message);
			}
		}

		/// <summary>
		/// Event received from xisothread2.	
		/// WakeUp Main thread.
		/// </summary>
		void EventFileThread (object sender, EventArgs args)
		{
			main_notify.WakeupMain();
		}
		
		/// <summary>
		/// Update GUI from the main thread.
		/// </summary>
		void UpdateProgressBarThread ()
		{
			try
			{	
				if (file.TotSize == 0) {
					progressbar1.Text = String.Format ("Sending FileList...");
					progressbar2.Text = String.Format ("Sending FileList...");
				}
				else
				{
					// File remaining
					label21.Text = (file.totnbfile - file.nbfile).ToString();
					label24.Text = (file.TotSize/1048576).ToString(".##") + " Mo";
	
					// Elapsed time
					TimeSpan interval = (DtStartNow - DateTime.Now).Duration();
					label28.Text = String.Format("{0}:{1:00}:{2:00}", interval.Hours, interval.Minutes, interval.Seconds);
	
					// Speed
					label27.Text = String.Format("{0}", (10000000/1024 * file.sendsize/(DateTime.Now.Ticks - initTime)).ToString(".##")) + " kb/s";
					
					// Update file progress bar
					progressbar1.Fraction = (file.sendsize / file.totsendsize);
					progressbar1.Text = String.Format ("{0}", (file.sendsize/file.totsendsize).ToString("#%"));
	
					// Update Tot progress bar
					progressbar2.Fraction = (file.TotSendSize/file.TotSize);
					progressbar2.Text = String.Format ("{0}", (file.TotSendSize/file.TotSize).ToString("#.#%"));				
				}
				#if (DEBUG)
					Console.WriteLine("\n------------" +
				                  "\n%==>" +  (file.sendsize/file.totsendsize) +
				                  "\nTot %==>" + (file.TotSendSize/file.TotSize) +
				                  "\n-----------\n");
				#endif			
			}
			// Catching the abort button side effects.
			catch (Exception e)
			{
				#if (DEBUG)
					Console.WriteLine("Exception: (In ProgressUploadDirGlade::UpdateProgressBarThread):\n" + e.Message +
						"\nSilently ignoring and killing the dialog.");
				#endif
				this.Close();
			}
		}		
	
		/// <summary>
		/// Execute thread.	
		/// </summary>	
		void progress_Thread()
		{
			try
			{
				file.FtpJob();
				Response = (int)ResponseType.Ok;
				// Kill the thread because we are done
				progress_worker.Abort();
				dialog2.Hide ();
				#if (DEBUG)
					Console.WriteLine("End progress_Thread");
				#endif
			}
			// Catching the abort button side effects.
			catch (System.Exception e)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (In ProgressUploadDirGlade::progress_Thread):\n" + e.Message);
				#endif
				// Kill the thread
				dialog2.Hide();
				file.Close();
				progress_worker.Abort();
				throw e;
			}
		}

		private void Dialog_Cancel (object o, EventArgs args)
		{
			Response = (int)ResponseType.Cancel;
			dialog2.Hide ();
		}

		public void Run ()
		{			
			ThreadStart tstart = new ThreadStart (progress_Thread);
			progress_worker = new Thread (tstart);
			progress_worker.Start ();
			main_notify = new Gtk.ThreadNotify (new Gtk.ReadyEvent (UpdateProgressBarThread));
			dialog2.ShowAll();
			dialog2.Run();
		}

		public void Close()
		{
			dialog2.Destroy();
			file = null;
			System.GC.Collect();
		}
	}
}
