/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

import org.farng.mp3.TagConstants;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectStringHashMap
    extends ObjectStringFixedLength
    implements ObjectHashMapInterface {
    /** DOCUMENT ME! */
    public static final String LANGUAGE = "Language";

    /** DOCUMENT ME! */
    HashMap idToString = null;

    /** DOCUMENT ME! */
    HashMap stringToId = null;

    /** DOCUMENT ME! */
    boolean hasEmptyValue = false;

    /**
     * Creates a new ObjectStringHashMap object.
     *
     * @param identifier DOCUMENT ME!
     * @param size DOCUMENT ME!
     */
    public ObjectStringHashMap(String identifier, int size) {
        super(identifier, size);

        if (identifier.equals(ObjectStringHashMap.LANGUAGE)) {
            stringToId = TagConstants.languageStringToId;
            idToString = TagConstants.languageIdToString;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getIdToString() {
        return idToString;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getStringToId() {
        return stringToId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param value DOCUMENT ME!
     */
    public void setValue(Object value) {
        if (value instanceof String) {
            this.value = ((String) value).toLowerCase();
        } else {
            this.value = value;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectStringHashMap) == false) {
            return false;
        }

        ObjectStringHashMap object = (ObjectStringHashMap) obj;

        if (this.hasEmptyValue != object.hasEmptyValue) {
            return false;
        }

        if (this.idToString.equals(object.idToString) == false) {
            return false;
        }

        if (this.stringToId.equals(object.stringToId) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        if (idToString == null) {
            return null;
        } else {
            // put them in a treeset first to sort them
            TreeSet treeSet = new TreeSet(idToString.values());

            if (hasEmptyValue) {
                treeSet.add("");
            }

            return treeSet.iterator();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        if (value == null) {
            return "";
        } else if (idToString.get(value) == null) {
            return "";
        } else {
            return idToString.get(value)
                   .toString();
        }
    }
}