/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import org.farng.mp3.TagUtilities;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectNumberFixedLength
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    int length = 0;

    /**
     * Creates a new ObjectNumberFixedLength object.
     *
     * @param identifier DOCUMENT ME!
     * @param size DOCUMENT ME!
     */
    public ObjectNumberFixedLength(String identifier, int size) {
        this.length     = size;
        this.identifier = identifier;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getLength() {
        return length;
    }

    /**
     * DOCUMENT ME!
     *
     * @param length DOCUMENT ME!
     */
    public void setSize(int length) {
        if (length > 0) {
            this.length = length;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return length;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectNumberFixedLength) == false) {
            return false;
        }

        ObjectNumberFixedLength object = (ObjectNumberFixedLength) obj;

        if (this.length != object.length) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param arr DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readByteArray(byte[] arr, int offset) {
        long lvalue = 0;

        for (int i = offset; i < (offset + length); i++) {
            lvalue <<= 8;
            lvalue += arr[i];
        }

        value = new Long(lvalue);
    }

    /**
     * DOCUMENT ME!
     *
     * @param str DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readString(String str, int offset) {
        value = Long.getLong(str.substring(offset));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        if (value == null) {
            return "";
        } else {
            return value.toString();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public byte[] writeByteArray() {
        byte[] arr;

        if (value == null) {
            arr = new byte[0];
        } else {
            long temp = TagUtilities.getWholeNumber(value);
            arr = new byte[length];

            for (int i = length - 1; i >= 0; i--) {
                arr[i] = (byte) (temp & 0xFF);
                temp >>= 8;
            }
        }

        return arr;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String writeString() {
        if (value == null) {
            return "";
        } else {
            return value.toString();
        }
    }
}