/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectLyrics3TimeStamp
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    private int minute = 0;

    /** DOCUMENT ME! */
    private int second = 0;

    /**
     * Creates a new ObjectLyrics3TimeStamp object.
     */
    public ObjectLyrics3TimeStamp() {}

    /**
     * Creates a new ObjectLyrics3TimeStamp object.
     *
     * @param timeStamp DOCUMENT ME!
     */
    public ObjectLyrics3TimeStamp(String timeStamp) {
        this.readString(timeStamp, 0);
    }

    /**
     * Creates a new ObjectLyrics3TimeStamp object.
     *
     * @param timeStamp DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public ObjectLyrics3TimeStamp(String timeStamp, int offset) {
        this.readString(timeStamp, offset);
    }

    /**
     * Creates a new ObjectLyrics3TimeStamp object.
     *
     * @param timeStamp DOCUMENT ME!
     * @param timeStampFormat DOCUMENT ME!
     */
    public ObjectLyrics3TimeStamp(int timeStamp, byte timeStampFormat) {
        /**
         * @todo-javadoc convert both types of formats
         */
        timeStamp = timeStamp / 1000;
        minute    = timeStamp / 60;
        second    = timeStamp % 60;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMinute() {
        return minute;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSecond() {
        return second;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return 7;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectLyrics3TimeStamp) == false) {
            return false;
        }

        ObjectLyrics3TimeStamp object = (ObjectLyrics3TimeStamp) obj;

        if (this.minute != object.minute) {
            return false;
        }

        if (this.second != object.second) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param timeStamp DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readString(String timeStamp, int offset) {
        timeStamp = timeStamp.substring(offset);

        if (timeStamp.length() == 7) {
            minute = Integer.parseInt(timeStamp.substring(1, 3));
            second = Integer.parseInt(timeStamp.substring(4, 6));
        } else {
            minute = 0;
            second = 0;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return writeString();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String writeString() {
        String str;
        str = "[";

        if (minute < 10) {
            str += '0';
        }

        str += Integer.toString(minute);
        str += ':';

        if (second < 10) {
            str += '0';
        }

        str += Integer.toString(second);
        str += ']';

        return str;
    }
}