/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import java.util.Iterator;
import java.util.LinkedList;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectLyrics3Line
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    private LinkedList timeStamp = new LinkedList();

    /** DOCUMENT ME! */
    private String lyric = "";

    /**
     * Creates a new ObjectLyrics3Line object.
     */
    public ObjectLyrics3Line() {}

    /**
     * Creates a new ObjectLyrics3Line object.
     *
     * @param lineString DOCUMENT ME!
     */
    public ObjectLyrics3Line(String lineString) {
        this.readString(lineString, 0);
    }

    /**
     * Creates a new ObjectLyrics3Line object.
     *
     * @param lineString DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public ObjectLyrics3Line(String lineString, int offset) {
        this.readString(lineString, offset);
    }

    /**
     * Creates a new ObjectLyrics3Line object.
     *
     * @param line DOCUMENT ME!
     * @param timeStampFormat DOCUMENT ME!
     */
    public ObjectLyrics3Line(ObjectID3v2LyricLine line, byte timeStampFormat) {
        this.lyric = line.getText();
        timeStamp.add(new ObjectLyrics3TimeStamp(line.getTimeStamp(),
                                                 timeStampFormat));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getLyric() {
        return lyric;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int size = 0;

        for (int i = 0; i < timeStamp.size(); i++) {
            size += ((ObjectLyrics3TimeStamp) timeStamp.get(i)).getSize();
        }

        return size + lyric.length();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator getTimeStamp() {
        return timeStamp.iterator();
    }

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void addTimeStamp(ObjectLyrics3TimeStamp time) {
        timeStamp.add(time);
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectLyrics3Line) == false) {
            return false;
        }

        ObjectLyrics3Line object = (ObjectLyrics3Line) obj;

        if (this.lyric.equals(object.lyric) == false) {
            return false;
        }

        if (this.timeStamp.equals(object.timeStamp) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean hasTimeStamp() {
        if (timeStamp.isEmpty()) {
            return false;
        }

        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param lineString DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readString(String lineString, int offset) {
        int                    delim = 0;
        ObjectLyrics3TimeStamp time;
        timeStamp = new LinkedList();

        delim = lineString.indexOf("[", offset);

        while (delim >= 0) {
            offset = lineString.indexOf("]", delim) + 1;
            time   = new ObjectLyrics3TimeStamp(lineString.substring(delim,
                                                                     offset));
            timeStamp.add(time);
            delim = lineString.indexOf("[", offset);
        }

        lyric = lineString.substring(offset);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String str = "";

        for (int i = 0; i < timeStamp.size(); i++) {
            str += timeStamp.get(i)
                   .toString();
        }

        return "timeStamp = " + str + ", lyric = " + lyric + "\n";
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String writeString() {
        String                 str  = "";
        ObjectLyrics3TimeStamp time;

        for (int i = 0; i < timeStamp.size(); i++) {
            time = (ObjectLyrics3TimeStamp) timeStamp.get(i);
            str += time.writeString();
        }

        return str + lyric;
    }
}