/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyWXXX
    extends AbstractID3v2FrameBody {
    /** DOCUMENT ME! */
    String description = "";

    /** DOCUMENT ME! */
    String urlLink = "";

    /** DOCUMENT ME! */
    byte textEncoding = 0;

    /**
     * Creates a new FrameBodyWXXX object.
     */
    public FrameBodyWXXX() {
        //        this.setObject("Text Encoding", new Byte((byte) 0));
        //        this.setObject("Description", "");
        //        this.setObject("URL", "");
    }

    /**
     * Creates a new FrameBodyWXXX object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param urlLink DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyWXXX(byte textEncoding, String description, String urlLink,
                         boolean is6ByteHeader) {
        this.setObject("Text Encoding",
                       new Byte(textEncoding));
        this.setObject("Description", description);
        this.setObject("URL", urlLink);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyWXXX object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyWXXX(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getBriefDescription() {
        return this.getUrlLink();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "WXXX" + ((char) 0) + description;
    }

    /**
     * DOCUMENT ME!
     *
     * @param urlLink DOCUMENT ME!
     */
    public void setUrlLink(String urlLink) {
        setObject("URL", urlLink);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUrlLink() {
        return (String) getObject("URL");
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof FrameBodyWXXX) == false) {
            return false;
        }

        FrameBodyWXXX object = (FrameBodyWXXX) obj;

        if (this.description.equals(object.description) == false) {
            return false;
        }

        if (this.textEncoding != object.textEncoding) {
            return false;
        }

        if (this.urlLink.equals(object.urlLink) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap("Text Encoding", 1));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectStringSizeTerminated("URL"));
    }
}