/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringDate;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyCOMR
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyCOMR object.
     */
    public FrameBodyCOMR() {
        //        this.setObject("Text Encoding", new Byte((byte) 0));
        //        this.setObject("Price String", "");
        //        this.setObject("Valid Until", "");
        //        this.setObject("Contact URL", "");
        //        this.setObject("Recieved As", new Byte((byte) 0));
        //        this.setObject("Name Of Seller", "");
        //        this.setObject("Description", "");
        //        this.setObject("Picture MIME Type", "");
        //        this.setObject("Seller Logo", new byte[0]);
    }

    /**
     * Creates a new FrameBodyCOMR object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param priceString DOCUMENT ME!
     * @param validUntil DOCUMENT ME!
     * @param contactUrl DOCUMENT ME!
     * @param recievedAs DOCUMENT ME!
     * @param nameOfSeller DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param mimeType DOCUMENT ME!
     * @param sellerLogo DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyCOMR(byte textEncoding, String priceString,
                         String validUntil, String contactUrl, byte recievedAs,
                         String nameOfSeller, String description,
                         String mimeType, byte[] sellerLogo,
                         boolean is6ByteHeader) {
        this.setObject("Text Encoding",
                       new Byte(textEncoding));
        this.setObject("Price String", priceString);
        this.setObject("Valid Until", validUntil);
        this.setObject("Contact URL", contactUrl);
        this.setObject("Recieved As",
                       new Byte(recievedAs));
        this.setObject("Name Of Seller", nameOfSeller);
        this.setObject("Description", description);
        this.setObject("Picture MIME Type", mimeType);
        this.setObject("Seller Logo", sellerLogo);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyCOMR object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyCOMR(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        String             str      = "COMR";
        AbstractMP3Object  object;
        java.util.Iterator iterator = objectList.listIterator();

        while (iterator.hasNext()) {
            object = (AbstractMP3Object) iterator.next();
            str += (((char) 0) + getOwner());
        }

        return str;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner() {
        return (String) getObject("Owner");
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void getOwner(String description) {
        setObject("Owner", description);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap(ObjectNumberHashMap.TEXT_ENCODING,
                                               1));
        objectList.add(new ObjectStringNullTerminated("Price String"));
        objectList.add(new ObjectStringDate("Valid Until"));
        objectList.add(new ObjectStringNullTerminated("Contact URL"));
        objectList.add(new ObjectNumberHashMap(ObjectNumberHashMap.RECIEVED_AS,
                                               1));
        objectList.add(new ObjectStringNullTerminated("Name Of Seller"));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectStringNullTerminated("Picture MIME Type"));
        objectList.add(new ObjectByteArraySizeTerminated("Seller Logo"));
    }
}