/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;

import org.farng.mp3.AbstractMP3FragmentBody;
import org.farng.mp3.InvalidTagException;


/**
 * DOCUMENT ME!
 *
 * @author Eric Farng Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractID3v2FrameBody
    extends AbstractMP3FragmentBody {
    /** DOCUMENT ME! */
    protected boolean is6ByteHeader = false;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @todo-javadoc remove this eventually
     */
    public String getIdentifier() {
        return "";
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof AbstractID3v2FrameBody) == false) {
            return false;
        }

        AbstractID3v2FrameBody object = (AbstractID3v2FrameBody) obj;

        if (this.is6ByteHeader != object.is6ByteHeader) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    protected int readHeader(RandomAccessFile file)
                      throws IOException, InvalidTagException {
        int    size;
        byte[] buffer = new byte[3];

        if (is6ByteHeader) {
            // read the 3 byte size
            file.read(buffer, 0, 3);
            size = (int) ((buffer[0] * Math.pow(2, 16)) +
                   (buffer[1] * Math.pow(2, 8)) + buffer[2]);
        } else {
            // read the 4 byte size
            size = file.readInt();

            // we need to skip the flag bytes;
            file.skipBytes(2);
        }

        if (size == 0) {
            throw new InvalidTagException("Found empty frame");
        }

        if ((size <= 0) || (size > file.length())) {
            throw new InvalidTagException("Invalid size for Frame Body");
        }

        return size;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     * @param size DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    protected void writeHeader(RandomAccessFile file, int size)
                        throws IOException {
        byte[] buffer = new byte[3];

        if (is6ByteHeader) {
            // write the 3 byte size;
            buffer[0] = (byte) ((size & 0x00FF0000) >> 16);
            buffer[1] = (byte) ((size & 0x0000FF00) >> 8);
            buffer[2] = (byte) (size & 0x000000FF);
            file.write(buffer);
        } else {
            // write the 4 byte size;
            file.writeInt(size);

            // need to skip 2 flag bytes
            file.skipBytes(2);
        }
    }
}