/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.filename;

import java.util.Iterator;

import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.id3.AbstractID3v2FrameBody;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author $author$
 * @version $Revision: 1.1 $
 */
public class FilenameDelimiter
    extends FilenameComposite {
    /** DOCUMENT ME! */
    FilenameComposite afterComposite;

    /** DOCUMENT ME! */
    FilenameComposite beforeComposite;

    /** DOCUMENT ME! */
    String delimiter;

    /**
     * Creates a new FilenameDelimiter object.
     */
    public FilenameDelimiter() {}

    /**
     * DOCUMENT ME!
     *
     * @param afterComposite DOCUMENT ME!
     */
    public void setAfterComposite(FilenameComposite afterComposite) {
        this.afterComposite = afterComposite;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public FilenameComposite getAfterComposite() {
        return afterComposite;
    }

    /**
     * DOCUMENT ME!
     *
     * @param beforeComposite DOCUMENT ME!
     */
    public void setBeforeComposite(FilenameComposite beforeComposite) {
        this.beforeComposite = beforeComposite;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public FilenameComposite getBeforeComposite() {
        return beforeComposite;
    }

    /**
     * DOCUMENT ME!
     *
     * @param delimiter DOCUMENT ME!
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDelimiter() {
        return delimiter;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String composeFilename() {
        String filename = "";

        if (beforeComposite != null) {
            filename += beforeComposite.composeFilename();
        }

        filename += (delimiter + " ");

        if (afterComposite != null) {
            filename += afterComposite.composeFilename();
        }

        return filename;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        return new FilenameDelimiterIterator(this);
    }

    /**
     * DOCUMENT ME!
     *
     * @param id3v2FrameBodyClass DOCUMENT ME!
     */
    public void matchAgainstKeyword(Class id3v2FrameBodyClass) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(id3v2FrameBodyClass)) {
            if (beforeComposite != null) {
                beforeComposite.matchAgainstKeyword(id3v2FrameBodyClass);
            }

            if (afterComposite != null) {
                afterComposite.matchAgainstKeyword(id3v2FrameBodyClass);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param matchTag DOCUMENT ME!
     */
    public void matchAgainstTag(AbstractMP3Tag matchTag) {
        if (matchTag != null) {
            if (beforeComposite != null) {
                beforeComposite.matchAgainstTag(matchTag);
            }

            if (afterComposite != null) {
                afterComposite.matchAgainstTag(matchTag);
            }
        }
    }
}