#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/10/25 KaYa
/// first release
///
/// </summary>
#endregion

using System;
using System.IO;
using System.Xml;
using System.Collections;
using Xbgm.Core;

namespace Xbgm
{
	public class SaveXml
	{
		private static string XmlFile = "save.xml";
		private XmlTextWriter writer = null;
		private XmlDocument xmldoc;
		private FileStream 	fs;
		
		public string	name;
		public string	id;
		
		public SaveXml()
		{
			if (!System.IO.File.Exists(XmlFile))
				WriteDefaultConfig();
		}
		
		public void SaveOpen()
		{	
			fs = new FileStream(XmlFile,FileMode.Open,FileAccess.Read,FileShare.ReadWrite);
			xmldoc = new XmlDocument();
			xmldoc.Load(fs);
		}

		public void SaveClose()
		{	
			fs.Close();
		}

		public void DisplayGame()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Save");
			Console.WriteLine("Here is the list of Save Game: {0}\n", xmlnode[0].ChildNodes.Count);
			XmlNode root = xmlnode[0].FirstChild;
			for(int i=0; i < xmlnode[0].ChildNodes.Count; i++) // One by Game
			{
				XmlAttributeCollection xmlattrc = root.Attributes;
				Console.Write("Id: {0}\tGameName: {1}\n",  
							xmlattrc[0].Value, xmlattrc[1].Value);
				//Display the contents of the child nodes.
				if (root.HasChildNodes)
				{
					Console.WriteLine("In Game ChildNodes.Count: {0}", root.ChildNodes.Count);
					for (int j=0; j<root.ChildNodes.Count; j++)
					{
						xmlattrc = root.ChildNodes[j].Attributes;
						Console.WriteLine("Profil_Id: {0}\tProfil_Name: {1}", 
						                  xmlattrc[0].Value, xmlattrc[1].Value);
					}
				}
				Console.WriteLine();
				root = root.NextSibling;
			}
		}
		
		public SaveInfo[] GetAllXboxGame()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Save");
			XmlNode root = xmlnode[0].FirstChild;
			SaveInfo[] temp2 = new SaveInfo[xmlnode[0].ChildNodes.Count];		
			int count = 0;
			for(int i=0; i < xmlnode[0].ChildNodes.Count; i++) // One by Game
			{
				ArrayList profil = new ArrayList();
				XmlAttributeCollection xmlattrc = root.Attributes;
				if (root.HasChildNodes)
				{
					for (int j=0; j<root.ChildNodes.Count; j++)
					{
						XmlAttributeCollection xmlattrcchild = root.ChildNodes[j].Attributes;
						profil.Add(xmlattrcchild[0].Value);
						profil.Add(xmlattrcchild[1].Value);
					}
				}
				else { profil = null; }
				SaveInfo save = new SaveInfo(xmlattrc[1].Value, xmlattrc[0].Value, profil);
				if (save != null)
				{
					temp2[count++] = save;
				}
				root = root.NextSibling;
			}
			SaveInfo[] MySaveInfo = new SaveInfo[count];
			Array.Copy(temp2, 0, MySaveInfo, 0, count);
			temp2 = null;
			return MySaveInfo;
		}

		/// <summary>
		///  Save all when backup all
 		/// </summary>
		public void SaveAll(SaveInfo[] MySaveInfo)
		{
			Save();
			for(int i = 0; i < MySaveInfo.Length; i++) {
				writer.WriteStartElement("Game");
				writer.WriteAttributeString("ID", MySaveInfo[i].Id);
				writer.WriteAttributeString("Name", MySaveInfo[i].Name);
				if (MySaveInfo[i].profil != null && MySaveInfo[i].profil.Count != 0) {
					for(int j = 0; j < MySaveInfo[i].profil.Count; j= j +2) {
						writer.WriteStartElement("Profil");
					    writer.WriteAttributeString("Dir", MySaveInfo[i].profil[j].ToString());
					    writer.WriteAttributeString("Name", MySaveInfo[i].profil[j+1].ToString());
					    writer.WriteEndElement(); //Profil
					}
				}
				writer.WriteEndElement(); // Game
			}
			Close();
		}

		/// <summary>
		///  Remove one SaveGame from XML file
 		/// </summary>
		public void RemoveOne(SaveInfo[] MySaveInfo, string id)
		{
			Save();
			for(int i = 0; i < MySaveInfo.Length; i++) {
				if (!MySaveInfo[i].Id.Equals(id))  // If the element we want to remove
				{
					writer.WriteStartElement("Game");
					writer.WriteAttributeString("ID", MySaveInfo[i].Id);
					writer.WriteAttributeString("Name", MySaveInfo[i].Name);
					if (MySaveInfo[i].profil != null && MySaveInfo[i].profil.Count != 0) {
						for(int j = 0; j < MySaveInfo[i].profil.Count; j= j +2) {
							if (!MySaveInfo[i].profil[j].Equals(id)) // If the element we want to remove
							{
								writer.WriteStartElement("Profil");
							    writer.WriteAttributeString("Dir", MySaveInfo[i].profil[j].ToString());
							    writer.WriteAttributeString("Name", MySaveInfo[i].profil[j+1].ToString());
							    writer.WriteEndElement(); //Profil
							}
						}
					}
					writer.WriteEndElement(); // Game
				}
			}
			Close();
		}

		public void WriteDefaultConfig()
		{
			Save();
			writer.WriteStartElement("Game");
		    writer.WriteAttributeString("ID", "001" );
		    writer.WriteAttributeString("Name", "My Test Game");
		    writer.WriteStartElement("Profil");
		    writer.WriteAttributeString("Dir", "0001" );
		    writer.WriteAttributeString("Name", "My Test Profil 01");
		    writer.WriteEndElement(); // Profil
		    writer.WriteStartElement("Profil");
		    writer.WriteAttributeString("Dir", "0002" );
		    writer.WriteAttributeString("Name", "My Test Profil 02");
		    writer.WriteEndElement(); // Profil
			writer.WriteEndElement(); // Game
			Close();
		}

		public void Save()
		{
			writer = new XmlTextWriter(XmlFile,System.Text.UTF8Encoding.UTF8);
		   	writer.Formatting = Formatting.Indented;
			writer.Indentation = 2;
			writer.IndentChar = ' ';
			writer.WriteStartDocument ( true );
			writer.WriteStartElement("Xbgmsharp");
			writer.WriteStartElement("Save");
		}
		
		public void Close()
		{
			// end the root element
   			writer.WriteEndElement(); // Save
   			writer.WriteEndElement(); // Xbgmsharp
   			writer.Flush(); 
			writer.Close();
		}
	}
}
