#include <stdio.h>
#include <openxdk/debug.h>
#include <hal/xbox.h>

#define SCREEN_WIDTH  640
#define SCREEN_HEIGHT 480
#define FONT_WIDTH      8
#define FONT_HEIGHT     8
#define MARGIN         20

int nextRow = MARGIN;
int nextCol = MARGIN; 

// a very simple 256 char bitmapped font
// that was blatantly liberated from the 
// www.svgalib.org site. Graciously provided
// by John Remyn, originally distributed
// with sasteroids.
static unsigned char systemFont[] =
{
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,56,56,56,56,56,0,56,56,
	108,108,0,0,0,0,0,0,0,108,254,254,108,254,254,108,
	48,126,224,124,14,254,252,48,98,230,204,24,48,102,206,140,
	120,220,252,120,250,222,252,118,28,28,56,0,0,0,0,0,
	14,28,28,28,28,28,28,14,112,56,56,56,56,56,56,112,
	0,0,0,230,124,56,124,206,0,0,28,28,127,127,28,28,
	0,0,0,0,0,28,28,56,0,0,0,0,124,124,0,0,
	0,0,0,0,0,0,56,56,28,28,56,56,112,112,224,224,
	124,254,238,238,238,254,254,124,56,120,248,56,56,254,254,254,
	252,254,14,60,112,254,254,254,252,254,14,60,14,254,254,252,
	238,238,238,254,254,14,14,14,254,254,224,252,14,254,254,252,
	124,252,224,252,238,254,254,124,252,254,14,14,28,28,56,56,
	124,254,238,124,238,254,254,124,124,254,238,126,14,254,254,252,
	0,0,28,28,0,28,28,28,0,0,28,28,0,28,28,56,
	6,14,28,56,56,28,14,6,0,0,124,124,0,124,124,124,
	112,56,28,14,14,28,56,112,124,254,206,28,56,0,56,56,
	124,198,190,182,190,182,200,126,124,254,238,254,238,238,238,238,
	252,254,206,252,206,254,254,252,124,254,238,224,238,254,254,124,
	252,254,238,238,238,254,254,252,254,254,224,248,224,254,254,254,
	126,254,224,248,224,224,224,224,126,254,224,238,238,254,254,124,
	238,238,238,254,238,238,238,238,254,254,56,56,56,254,254,254,
	254,254,14,14,238,254,254,124,238,238,252,248,252,238,238,238,
	224,224,224,224,224,254,254,126,130,198,238,254,254,238,238,238,
	206,238,254,254,254,254,238,230,124,254,238,238,238,254,254,124,
	252,254,238,238,252,224,224,224,124,254,238,238,254,254,252,118,
	252,254,238,238,252,238,238,238,126,254,224,124,14,254,254,252,
	254,254,56,56,56,56,56,56,238,238,238,238,238,254,254,124,
	238,238,238,238,238,238,124,56,238,238,238,254,254,238,198,130,
	238,238,124,56,124,238,238,238,238,238,124,124,56,56,112,112,
	254,254,28,56,112,254,254,254,124,124,112,112,112,124,124,124,
	112,112,56,56,28,28,14,14,124,124,28,28,28,124,124,124,
	56,124,238,198,0,0,0,0,0,0,0,0,0,254,254,254,
	56,56,28,0,0,0,0,0,0,124,254,238,254,238,238,238,
	0,252,254,206,252,206,254,252,0,124,254,238,224,238,254,124,
	0,252,254,238,238,238,254,252,0,254,254,224,248,224,254,254,
	0,126,254,224,248,224,224,224,0,126,254,224,238,238,254,124,
	0,238,238,238,254,238,238,238,0,254,254,56,56,56,254,254,
	0,254,254,14,14,238,254,124,0,238,238,252,248,252,238,238,
	0,224,224,224,224,224,254,126,0,130,198,238,254,254,238,238,
	0,206,238,254,254,254,238,230,0,124,254,238,238,238,254,124,
	0,252,254,238,238,252,224,224,0,124,254,238,238,254,252,118,
	0,252,254,238,238,252,238,238,0,126,254,224,124,14,254,252,
	0,254,254,56,56,56,56,56,0,238,238,238,238,238,254,124,
	0,238,238,238,238,238,124,56,0,238,238,238,254,238,198,130,
	0,238,238,124,56,124,238,238,0,238,238,124,124,56,56,112,
	0,254,254,28,56,112,254,254,60,124,112,112,112,124,124,60,
	56,56,56,0,56,56,56,56,120,124,28,28,28,124,124,120,
	236,254,118,0,0,0,0,0,0,16,56,124,254,254,254,254,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

void drawChar(unsigned char c, int x, int y, int fgColour, int bgColour)
{
	int *videoBuffer = (int *)XBOX_VIDEO_ADDRESS;
	videoBuffer += y*SCREEN_WIDTH+x;

	unsigned char mask;
	unsigned char *font = systemFont + (c * FONT_WIDTH);

	for (int h = 0; h < FONT_HEIGHT; h++)
	{
		mask = 0x80;
		for (int w = 0; w < FONT_WIDTH; w++)
		{
			if ((*font) & mask)
			{
				// draw pixel
				*videoBuffer++ = fgColour;
			}
			else
			{
				// draw background colour
				*videoBuffer++ = bgColour;
			}
			
			mask >>= 1;
		}
		
		videoBuffer += (SCREEN_WIDTH-FONT_WIDTH);
		font++;
	}
}

// given an unsigned nibble (4 bits) between 0x00 to 0x0F, return '0' to 'F'
char n2c(int byte)
{
	switch(byte)
	{
		case 0x00: return '0';
		case 0x01: return '1';
		case 0x02: return '2';
		case 0x03: return '3';
		case 0x04: return '4';
		case 0x05: return '5';
		case 0x06: return '6';
		case 0x07: return '7';
		case 0x08: return '8';
		case 0x09: return '9';
		case 0x0A: return 'A';
		case 0x0B: return 'B';
		case 0x0C: return 'C';
		case 0x0D: return 'D';
		case 0x0E: return 'E';
		case 0x0F: return 'F';
		default: return '?';
	}
}

void debugPrintNum(int i)
{
	char num[11];
	num[0] = '0';
	num[1] = 'x';
	num[2] = n2c((i >> 28) & 0x0F);
	num[3] = n2c((i >> 24) & 0x0F);
	num[4] = n2c((i >> 20) & 0x0F);
	num[5] = n2c((i >> 16) & 0x0F);
	num[6] = n2c((i >> 12) & 0x0F);
	num[7] = n2c((i >> 8) & 0x0F);
	num[8] = n2c((i >> 4) & 0x0F);
	num[9] = n2c((i >> 0) & 0x0F);
	num[10] = 0;
	debugPrint(num);
}

void debugPrint(char *format, ...)
{
	char buffer[512];
	unsigned short len;
	va_list argList;
	va_start(argList, format);
	vsprintf(buffer, format, argList);
	va_end(argList);
	
	unsigned char *s = buffer;
	while (*s)
	{
		if (*s == '\n')
		{
			nextRow += FONT_HEIGHT+1;
			nextCol = MARGIN;
		}
		else
		{
			drawChar(*s, nextCol, nextRow, WHITE, BLACK);

			nextCol += FONT_WIDTH+1;
			if (nextCol >= (SCREEN_WIDTH-MARGIN))
			{
				nextRow += FONT_HEIGHT+1;
				nextCol = MARGIN;
			}
		}
		s++;
	}

}

void debugPrintHex(char *buffer, int length)
{
	char tmp[10];
	for (int i = 0; i < length; i++)
	{
		sprintf(tmp, "%02x ", buffer[i]);
		debugPrint(tmp);
	}
}
