package kr.util.audio;



import kr.util.ByteBuffer;

public class MemAudioClip extends WritableAudioClip {
	private ByteBuffer bb = new ByteBuffer(1024, 1.1); //use 10 % multipy amount
	private int numChannels;
	private int rate;
	private int sampleSizeInBits;
	
	public MemAudioClip(int numChannels, int rate, int sampleSizeInBits)
	{
		this.numChannels = numChannels;
		this.rate = rate;
		this.sampleSizeInBits = sampleSizeInBits;
	}
	
	public int length() {
		return bb.length();
	}

	public byte byteAt(int index) {
		return bb.byteAt(index);
	}
	
	/**
	 * Sets the internal byte buffer array data to the given
	 * value. Used to save memory
	 */
	public void setInternalArray(byte [] data)
	{
		bb = new ByteBuffer(data);
	}

	public void copyTo(int offset, int length, byte[] dest, int destOffset) {
		bb.copyTo(offset, length, dest, destOffset);
	}

	public void append(byte[] data) { 
		bb.append(data);
	}

	public void copyFrom(int offset, int length, byte[] src, int srcOffset) {
		bb.copyFrom(offset, length, src, srcOffset);
		
	}

	public void append(byte[] data, int offset, int length) {
		bb.append(data,offset,length);
	}

	public int getNumChannels() {
		return numChannels;
	}

	public int getRate() {
		return rate;
	}

	public void setNumChannels(int numChannels) {
		this.numChannels = numChannels;
	}

	public void setRate(int rate) {
		this.rate = rate;
	}

	public int getSampleSizeInBits() {
		return sampleSizeInBits;
	}

	@Override
	public void ensureCapacityInFrames(long frameLength) {
		bb.ensureCapacity((int) (frameLength * getNumChannels() * getSampleSizeInBits() / 8 +1024));
	}

	public byte[] getInternalArray() {
		return bb.getInternalArray();
	}

}
