package kr.gui.util;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/**
 * Restricts RestrictedFields and RestrictedTextAreas by limiting the maximum length
 */
public class MaxLengthRestrictor extends InsertRestrictor 
{
	private int maxLength;

	public MaxLengthRestrictor(int maxLength)
	{
		this.maxLength = maxLength;
	}
	
	public String insertStringImpl(Document d, int offs, 
								 String str,
								 AttributeSet a) 
	{
		if((str != null) &&
			d.getLength() + str.length() > maxLength)
			str = str.substring(0, maxLength - d.getLength());
		
		return str;
	}
}

