package kr.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.event.ChangeListener;


public class MiscSettingsController  implements ActionListener
{
	private Model model;
	private MiscSettingsPanel panel;

	public void init(Model model, MiscSettingsPanel panel) {
		this.model = model;
		this.panel = panel;
		
		panel.createBackgroundFromVocals.addActionListener(this);
		panel.updateButton.addActionListener(this);
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == panel.createBackgroundFromVocals)
		{
			updateUpdateButtonStatus();
		}
		else if(e.getSource() == panel.updateButton)
		{
			//updateGuiModel();
			updateUpdateButtonStatus();
		}		
	}

	private void updateUpdateButtonStatus() {
		if(panel.createBackgroundFromVocals.isSelected() != model.getAudioModel().isCreateBackgroundFromVocals())
			panel.updateButton.setEnabled(true);
		else
			panel.updateButton.setEnabled(false);
	}

}
