package kr.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class KRViewerController implements KeyListener, WindowListener
{
	private KRViewer krViewer;
	private Model model;

	public KRViewerController()
	{
	}
	
	public void init(KRViewer krViewer, Model m)
	{
		this.krViewer = krViewer;
		krViewer.addWindowListener(this);
		this.model = m;
	}

	public void windowClosing(WindowEvent event) {
		if(model.getMidiFileModel().isModified())
		{
			if(JOptionPane.showInternalConfirmDialog(krViewer.getContentPane(), 
					new JLabel("Are you sure you want to exit without saving?"), "Confirm", JOptionPane.YES_NO_OPTION)
					== JOptionPane.NO_OPTION)
			{
				return;
			}
		}
		
		System.exit(0);
	}

	public void keyTyped(KeyEvent e) {
		//send events that make it here to
		
	}

	public void keyPressed(KeyEvent e) {
		krViewer.mg.dispatchEvent(e);
		
	}

	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowOpened(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosed(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowIconified(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeiconified(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowActivated(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeactivated(WindowEvent e) {
		// TODO Auto-generated method stub
		
	}
}
