/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/08/01 KaYa
/// first release
///
/// </summary>


/// <summary>
/// I translate xbiso code into C#
/// So here is the all xdvdfs (xbox iso) format
/// directly to the xbox via ftp 
/// </summary>
namespace Xbgm.Xiso
{
using System;
using System.IO;
using System.Text;
using System.Data;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using EnterpriseDT.Net.Ftp;
using System.Threading;
using Xbgm.Gui;
	
	class XisoExtractClass
	{
		private FTPClient ftp = null;
		private TcpClient client = null;
		private NetworkStream stream = null;
		
		// The dirent structure of a xiso
		public struct dirent
		{
		 public long	ltable;				//left entry
		 public long	rtable;				//right entry
		 public long	sector;				//sector of file
		 public long	size;				//size of file
		 public int		attribs;			//file attributes
		 public int		fnamelen;			//filename lenght
		 public string 	fname;				//filename
		 //public long	pad;				//padding (unused)
		}

		const string HEADERDATA = "MICROSOFT*XBOX*MEDIA";
		const int	 HEADERSIZE	= 20;
		const int	 HEADEROFF	= 0x10000;
		const int	 BUFFERSIZE	= 0x40000; //256k buffer
		 
		FileStream xisofs; //File Handling xiso
		StreamReader xisoReader; //Stream reader xiso

	/*	// TEST LIST TO FILE
		FileStream FileListWriter; //File Handling xiso
		StreamWriter xisoFileList; //Stream reader xiso
	*/
		public int Nbfiles = 0;
		public int Nbdir = 0;
		
		public string xisofilename = null;
		public bool docontinue = true;
		
		// Stats
		public string currentfile = null;
		public double currentsize = 0;	
		public double sendfile = 0;
		public double sendsize = 0;
		public double totsendsize = 0;
		public double sendsizefile = 0;
		
		// Action 
		public bool hdd = false;
				
		// File/Dir list of the xiso BOOST MODE
		ArrayList FileDirlist = new ArrayList(); 
		
		/// <summary>
		///  Check the header of the xiso.
		///  If ok go trought is not return
 		/// </summary>
		public void extractiso(string xisofile, string xboxdir, string gamedir, 
		                       string IP, int port, string user, string pass, string dir)
		{
			//Console.WriteLine("Start ISO extraction: [" + xisofile + "]");
			//Console.ReadLine();
			xisofilename = xisofile;

	        xisofs  = new FileStream(xisofile, FileMode.Open,
	                             	FileAccess.Read);
	        // Create a character reader.
	        xisoReader = new StreamReader(xisofs);
			
			// init stat var
			sendsize = 0;
			sendfile = 0;
			sendsizefile = 0;
			
		/*	// TEST LIST TO FILE
			FileListWriter = new FileStream(@"J:\xbox\FileList.txt", FileMode.CreateNew);
			xisoFileList = new StreamWriter(FileListWriter);
		*/	
			if(hdd)
			{
				Directory.SetCurrentDirectory(xboxdir);
				// Create and change to Game directory
				Directory.CreateDirectory(gamedir);
				Directory.SetCurrentDirectory(gamedir);
			}
	        // Set the StreamReader file pointer to the Beginning.
	        xisoReader.BaseStream.Seek( HEADEROFF, SeekOrigin.Begin);
			byte[] bufheader = new byte[20];
			int size = xisoReader.BaseStream.Read(bufheader, 0, bufheader.Length);
			if(size != 0)
			{					
				string s = System.Text.Encoding.ASCII.GetString(bufheader,0,HEADERSIZE);
				bufheader = null;
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error file doesnt appear to be a xbox iso image");
					return;
				}
				//Sector that root directory table resides in
				byte[] buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				long sectorroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Sector root directory ["+ sectorroot + "]");
				#endif
				//Size of root directory table in bytes
				buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				int sizeroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Size root directory ["+ sizeroot + "]");
				#endif
				//discard FILETIME structure representing image creation time
				xisoReader.BaseStream.Seek( 8, SeekOrigin.Current);
				//discard unused
				xisoReader.BaseStream.Seek( 0x7c8, SeekOrigin.Current);
				buf = new byte[20];
				size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
				s = System.Text.Encoding.ASCII.GetString(buf,0,buf.Length);
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error possible corruption?");
					return;
				}
				//Done With HEADER
				buf = null;
				s = null;
				if(hdd)
				{
					handlinghdd(sectorroot*2048, (int)sectorroot);
					Directory.SetCurrentDirectory(@"..");
				}
				else
				{
					FileDirlist.Add("D," + xboxdir + gamedir);
					handlingftplist(sectorroot*2048, (int)sectorroot, xboxdir + gamedir, xboxdir + gamedir);
				}
				if(!hdd)
				{
					try 
	  				{					
					/*	xisoFileList.Flush();
						xisoFileList.Close();
	  				*/	
	  					#if ( DEBUG )
							Console.WriteLine("Count:" + FileDirlist.Count);
	  					#endif
						ftp = new FTPClient(IP, port);
						#if ( DEBUG)
							ftp.DebugResponses(true);
						#endif
						ftp.Login(user, pass);
						ftp.System();
						ftp.TransferType = FTPTransferType.BINARY;
						ftp.ConnectMode = FTPConnectMode.ACTIVE;
						ftp.Site("FREEROOTSPACEDISABLE");
						ftp.Site("BOOST SUPPORTED");
						// NB entry in list i create. but should be NbFILES + NbDIR + 1GameDIR 
						ftp.Site("BOOST START UPLOAD " + FileDirlist.Count);
						//Console.ReadLine();
						int dataport = ftp.FileList(FileDirlist);
						//Console.ReadLine();
						client = new TcpClient(IP, dataport);
						stream = client.GetStream();
						handlingftpdata(sectorroot*2048, (int)sectorroot);
					    // Buffer to store the response bytes.
						Byte[] data = new Byte[256];
					
					/*  // String to store the response ASCII representation.
					    String responseData = String.Empty;
					
					    // Read the first batch of the TcpServer response bytes.
					    Int32 bytes = stream.Read(data, 0, data.Length);
						responseData = System.Text.Encoding.ASCII.GetString(data, 0, bytes);
						#if ( DEBUG)
	  						Console.WriteLine("Received: {0}", responseData);         
						#endif
					*/	data = System.Text.Encoding.ASCII.GetBytes("QUIT");
	  					stream.Write(data, 0, data.Length);
						client.Close();  
						ftp.QuitXbox();
	  					data = null;
	  					ftp = null;
	  					client = null;
	  					stream = null;
	  					//login.Close();
					} 
					catch (ArgumentNullException e) 
					{
					   Console.WriteLine("ArgumentNullException: {0}", e);
					} 
					catch (SocketException e) 
					{
					  Console.WriteLine("SocketException: {0}", e);
					}  
				}	
			}
			Int64 tmpsizemb = (Int64)xisofs.Length;
			#if ( DEBUG)
				Console.WriteLine("End of archive size:" +  (tmpsizemb>>=20) + " file:" + Nbfiles + " nbdir:" + Nbdir);
			#endif
			xisoReader.Close();
			xisofs.Close();
			xisoReader = null;
			xisofs = null;
			System.GC.Collect();
		// End extractiso
		}

		#region HDD
		/// <summary>
		/// Go trought the xiso to get info for extracting the file
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void handlinghdd(Int64 offset, Int64 dtable)
		{
			if (docontinue == false) {
				Console.WriteLine("Cancel");
				//Console.ReadLine();
				goto Finish;
			}
			dirent cur = new dirent();
			
			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif
				
			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if((cur.fname != null) && (cur.attribs == 16)) // attribs is a DIR
			{
				#if ( DEBUG)
					Console.WriteLine("Creating directory ["  + cur.fname + "]");
				#endif
				// Create the directory 
				// Then get into it...
				Directory.CreateDirectory(cur.fname);
				Directory.SetCurrentDirectory(cur.fname);		
				Nbdir++;
				// Call back handling
				handlinghdd(cur.sector*2048, (Int64)cur.sector);
				Directory.SetCurrentDirectory(@"..");
			}
			else
			{
				currentfile = cur.fname + " [" + (cur.size/1024) + " KB]";
				totsendsize = (int)cur.size;
				sendsize = 0;
				//So now we have to extract
				extracthdd(cur);
				sendfile++;
				sendsizefile += (double)cur.size;
				#if ( DEBUG )
					Console.WriteLine("Extracting ["+ cur.fname + "] " + sendfile + " of " + Nbfiles);
				#endif
				//Console.ReadLine();
			}	
			
		    if(cur.rtable != 0)
		         handlinghdd(dtable*2048+(cur.rtable*4), dtable);
		    if (cur.ltable != 0)
		      	handlinghdd(dtable*2048+(cur.ltable*4), dtable);			
		  //End handling
		  
		  Finish: return;
		}

		/// <summary>
		/// Extract a file on disk
		/// </summary>
		/// <param name="curt">The current dirent structure of a file</param>
		private bool extracthdd(dirent cur)
		{
			// Go to the right place
			xisoReader.BaseStream.Seek(cur.sector*2048, SeekOrigin.Begin);
			// Create the destination file
			System.IO.FileStream stream = new System.IO.FileStream(cur.fname, 
                                                    System.IO.FileMode.Create);
			BinaryWriter writer = new BinaryWriter(stream);
		
			// Create buffer
			int chunksize = 4096; //HDD
			byte[] chunk = new byte[chunksize];
			int size = (int)cur.size;
			sendsize = 0;
			IOException storedEx = null;
			// read from stream iso & write to file in chunks
			try
			{
				// do the extracting
				while(size > 0)
				{
					//Console.WriteLine("Extracting size [" + size + "]");
					
					if (size > chunksize)
					{
					size -= chunksize;
					sendsize += chunksize;
					xisoReader.BaseStream.Read(chunk, 0, chunk.Length);
					writer.Write(chunk);
					}
					else
					{
					xisoReader.BaseStream.Read(chunk, 0, size);
					writer.Write(chunk, 0, size);	
					size -= size;
					sendsize += size;
					}
				}
				//totsendsize = 0;
				//sendsize = size; 
			}
			catch (IOException ex)
			{
				storedEx = ex;
			}
			finally
			{
				// close destination streams
				writer.Close();
				chunk = null;
			}
			// close streams
			try
			{
				stream.Close();
			}
			catch (IOException)
			{
			}	
			// if we failed to write to the stream, rethrow the exception
			if (storedEx != null)
				throw storedEx;
			return true;
		}
		#endregion
		
		#region FTPList
		/// <summary>
		/// Go trought the xiso to get info for extracting the file
		/// This make the FTP FIle/Dir list for avalaunch dashboard
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void handlingftplist(Int64 offset, Int64 dtable, string fullpath, string oldpath)
		{
			dirent cur = new dirent();
			string msg = null;
			
			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif
				
			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if((cur.fname != null) && (cur.attribs == 16)) // attribs is a DIR
			{
				#if ( DEBUG)
					Console.WriteLine("Creating directory ["  + cur.fname + "]");
				#endif
				// Then get into it...
				oldpath = fullpath;
				fullpath = fullpath + @"\" + cur.fname;
				msg = @"D," + fullpath;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
				//Nbdir++;
				//Console.WriteLine("Fullpath: ["  + fullpath + "] Oldpath: [" + oldpath + "]");
				//Console.ReadLine();
				// Call back handling
				handlingftplist(cur.sector*2048, (Int64)cur.sector, fullpath, oldpath);
				fullpath = oldpath;
				msg = @"D," + fullpath;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
			}
			else
			{
				msg = @"F," + cur.fname + "," + cur.size;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
				#if  ( DEBUG )
					Console.WriteLine(msg);
				#endif
				//Console.ReadLine();
			}	
			
		    if(cur.rtable != 0)
		    {
		    	//Console.WriteLine("rtable" + cur.sector + "==" + cur.rtable);
		        handlingftplist(dtable*2048+(cur.rtable*4), dtable, fullpath, oldpath);
		    }
		    if (cur.ltable != 0)
		    {
		    	//Console.WriteLine("ltable" + cur.sector + "==" + cur.ltable);
		      	handlingftplist(dtable*2048+(cur.ltable*4), dtable, fullpath, oldpath);			
		    }		
		    msg = null;
		  //End handling
		}
		#endregion
		
		#region FTPDATA
		/// <summary>
		/// Go trought the xiso to get info 
		/// for extracting the file to FTP
		/// on network stream.
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void handlingftpdata(Int64 offset, Int64 dtable)
		{
			dirent cur = new dirent();

			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif
				
			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if((cur.fname != null) && (cur.attribs == 16)) // attribs is a DIR
			{
				// Nothing to do
				// it has allready been create prevously
				// Call back handling
				handlingftpdata(cur.sector*2048, (Int64)cur.sector);
			}
			else
			{
				currentfile = cur.fname + " [" + (cur.size/1024) + " KB]";
				totsendsize = (int)cur.size;
				sendsize = 0;
				extractftpdata(cur);
				sendfile++;
				sendsizefile += (double)cur.size;
				#if ( DEBUG)
					Console.WriteLine("Sending ["+ cur.fname + "] " + sendfile + " of " + Nbfiles);
				#endif
			}	
			
		    if(cur.rtable != 0)
		        handlingftpdata(dtable*2048+(cur.rtable*4), dtable);
		    if (cur.ltable != 0)
		      	handlingftpdata(dtable*2048+(cur.ltable*4), dtable);			
		  //End handling
		}


		/// <summary>
		/// Extract a file on the Xbox by FTP
		/// </summary>
		/// <param name="cur">The current dirent structure of a file</param>
		private bool extractftpdata(dirent cur)
		{
			// Go to the right place
			xisoReader.BaseStream.Seek(cur.sector*2048, SeekOrigin.Begin);

			// Create buffer
			int chunksize = 4096; //FTP
			byte[] chunk = new byte[chunksize];
			int size = (int)cur.size;
			// read from stream iso & write to file in chunks
			while(size > 0)
			{		
				//Console.WriteLine("Size =[" + size +"]");
				if (size > chunksize)
				{
					size -= chunksize;
					sendsize += chunksize;
					xisoReader.BaseStream.Read(chunk, 0, chunk.Length);
					stream.Write(chunk, 0, chunk.Length);
				}
				else
				{
					xisoReader.BaseStream.Read(chunk, 0, size);
					stream.Write(chunk, 0, size);
					size -= size;
					sendsize += size;
				}
			}
			sendsize = size;
			chunk = null;
			return true;
		}
		#endregion
	}
}
