// ******************************************************************
// * 
// * proj : Sample
// *
// * desc : Sample for Open Source XBox Development Kit
// *
// * file : main.cpp
// *
// * note : Tiny OpenXDK Animation
// *
// ******************************************************************
#include <openxdk.h>
#include <stdio.h>

// ******************************************************************
// * WinMainCRTStartup (Entry Point)
// ******************************************************************
void WinMainCRTStartup()
{
    // Currently, this is the only mode supported by xhal.lib
	InitMode( MODE_320x200x32 );

	char  buffer[1024];
    float last = (float)KeTickCount;
    int   fps  = 0;

    // Animate up and down
    int y=25, ys=1;

    // XBox software does not typically ever return from its entry point
	while(true)
    {
        // Wait for Vertical Blank
		WaitVBlank();

        // Flip
        Flip();

        // Clear screen
        Cls();

        fps  = (int)(1.0f/(((float)KeTickCount - last) / 1000.0f));
        last = (float)KeTickCount;

        // Print to screen
        {
		    sprintf(buffer,"OpenXDK Sample: %d fps", fps);

            Print(50,y, buffer);
        }

        y+=ys;

        if(y > 175 || y < 25)
            ys = -ys;
	}

    return;
}