/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;



/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectLyrics3Image
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    private ObjectLyrics3TimeStamp time = null;

    /** DOCUMENT ME! */
    private String description = "";

    /** DOCUMENT ME! */
    private String filename = "";

    /**
     * Creates a new ObjectLyrics3Image object.
     */
    public ObjectLyrics3Image() {}

    /**
     * Creates a new ObjectLyrics3Image object.
     *
     * @param filename DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param time DOCUMENT ME!
     */
    public ObjectLyrics3Image(String filename, String description,
                              ObjectLyrics3TimeStamp time) {
        this.filename    = filename;
        this.description = description;
        this.time        = time;
    }

    /**
     * Creates a new ObjectLyrics3Image object.
     *
     * @param imageString DOCUMENT ME!
     */
    public ObjectLyrics3Image(String imageString) {
        this.readString(imageString, 0);
    }

    /**
     * Creates a new ObjectLyrics3Image object.
     *
     * @param imageString DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public ObjectLyrics3Image(String imageString, int offset) {
        this.readString(imageString, offset);
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * DOCUMENT ME!
     *
     * @param filename DOCUMENT ME!
     */
    public void setFilename(String filename) {
        this.filename = filename;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getFilename() {
        return this.filename;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int size;

        size = filename.length() + 2 + description.length() + 2;

        if (time != null) {
            size += time.getSize();
        }

        return size;
    }

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setTimeStamp(ObjectLyrics3TimeStamp time) {
        this.time = time;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ObjectLyrics3TimeStamp getTimeStamp() {
        return this.time;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectLyrics3Image) == false) {
            return false;
        }

        ObjectLyrics3Image object = (ObjectLyrics3Image) obj;

        if (this.description.equals(object.description) == false) {
            return false;
        }

        if (this.filename.equals(object.filename) == false) {
            return false;
        }

        if (this.time.equals(object.time) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param imageString DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readString(String imageString, int offset) {
        String token;
        String timestamp;
        int    delim;

        delim    = imageString.indexOf("||", offset);
        filename = imageString.substring(offset, delim);

        offset      = delim + 2;
        delim       = imageString.indexOf("||", offset);
        description = imageString.substring(offset, delim);

        offset    = delim + 2;
        timestamp = imageString.substring(offset);

        if (timestamp.length() == 7) {
            time = new ObjectLyrics3TimeStamp(timestamp);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String str;
        str = "filename = " + filename + ", description = " + description;

        if (time != null) {
            str += (", timestamp = " + time.toString());
        }

        return str + "\n";
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String writeString() {
        String str;
        str = filename + "||" + description + "||";

        if (time != null) {
            str += time.writeString();
        }

        return str;
    }
}