/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringHashMap;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyUSER
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyUSER object.
     */
    public FrameBodyUSER() {
        //        setObject("Text Encoding", new Byte((byte) 0));
        //        setObject("Language", "");
        //        setObject("Text", "");
    }

    /**
     * Creates a new FrameBodyUSER object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param language DOCUMENT ME!
     * @param text DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyUSER(byte textEncoding, String language, String text,
                         boolean is6ByteHeader) {
        setObject("Text Encoding",
                  new Byte(textEncoding));
        setObject("Language", language);
        setObject("Text", text);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyUSER object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyUSER(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "USER" + ((char) 0) + getLanguage();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getLanguage() {
        return (String) getObject(ObjectStringHashMap.LANGUAGE);
    }

    /**
     * DOCUMENT ME!
     *
     * @param language DOCUMENT ME!
     */
    public void setOwner(String language) {
        setObject(ObjectStringHashMap.LANGUAGE, language);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap(ObjectNumberHashMap.TEXT_ENCODING,
                                               1));
        objectList.add(new ObjectStringHashMap(ObjectStringHashMap.LANGUAGE, 3));
        objectList.add(new ObjectStringSizeTerminated("Text"));
    }
}