/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3;

import java.io.IOException;
import java.io.RandomAccessFile;


/**
 * This class is a facade for all classes that can write to an MP3 file. It has
 * abstract methods that needs to be implemented, and a few default
 * implementations of other methods.
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractMP3FileItem {
    /**
     * ID string that usually corresponds to the class name, but can be
     * displayed to the user. It is not indended to identify each individual
     * instance.
     *
     * @return ID string
     */
    abstract public String getIdentifier();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public int getSize();

    /**
     * Method to read this object from the file argument at its current file
     * pointer position.
     *
     * @param file file to read from
     *
     * @throws TagException on any exception generated by this library.
     * @throws IOException on any I/O error
     */
    abstract public void read(RandomAccessFile file)
                       throws TagException, IOException;

    /**
     * Returns a string representation of the object
     *
     * @return a string representation of the object
     */
    abstract public String toString();

    /**
     * Method to write this object to the file argument at is current file
     * pointer position.
     *
     * @param file file to write to
     *
     * @throws IOException on any I/O error
     */
    abstract public void write(RandomAccessFile file)
                        throws IOException;

    /**
     * Returns true if this object is a subset of the argument. This instance
     * is a subset if it is the same class as the argument.
     *
     * @param obj object to determine subset of
     *
     * @return true if this instance and its entire object array list is a
     *         subset of the argument.
     */
    public boolean isSubsetOf(Object obj) {
        if ((obj instanceof AbstractMP3FileItem) == false) {
            return false;
        }

        return true;
    }
}