/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/12/12 KaYa
/// first release
///
/// </summary>

using System;
using System.Text;
using System.IO;

namespace Xbgm
{
	/// <summary>
	/// Configuration stuff 
	/// Read and Write Conf to File.
	/// </summary>
	public class Configuration
	{	
		private static string cfgFile = "xbgmsharp.conf";
		private Xbgm.FTP.Configuration ftpInfo;
		
		// Define if i use cache or not to show game list
		private bool cache = true;
		// Define if i use Gdrive or not to show free space
		private bool gDrive = true;
		// Xbox Media Center Full path + xbe
		private string XBMC = null;
		
		
		public Configuration()
		{
			this.ftpInfo = new Xbgm.FTP.Configuration(); 
			this.ReadConf();
		}

		public Configuration(Xbgm.FTP.Configuration ftpInfo, bool cache, bool gDrive, string XBMC)
		{
			this.ftpInfo = ftpInfo;
			this.cache = cache;
			this.gDrive = gDrive;
			this.XBMC = XBMC;
		}
		
		public void SaveConf()
		{		
			StreamWriter outputConfstream = null;
			try {
				outputConfstream = new StreamWriter(cfgFile);
			}

			catch(Exception e) {
			// TODO: 
//				AppendText("Error: Unable to write conf file. " + 
//					e.Message);
				Console.WriteLine("Error: Unable to write conf file. " + e.Message);
				return;
			}
	
			outputConfstream.WriteLine(this.ToString());
			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
		}
		
		public bool ReadConf()
		{
			#if (DEBUG)
				Console.WriteLine("Reading configuration.");
			#endif
			
			if(!File.Exists(cfgFile))
			{
				SetDefaultValues();
				this.SaveConf();
			}
			
			//Catch exception and exit 	if not fount WHY?
			StreamReader inputConfstream = null;
			try {
				inputConfstream = new StreamReader(cfgFile);
			}
			catch(Exception e) {
				//AppendText(buf , "Warning: Unable to open " + 
				//	e.Message);
				Console.WriteLine("Warning: Unable to open " + e.Message);
				return false;
			}
			
			#if (DEBUG)
				Console.WriteLine("Opened the file.");
			#endif
			
			string line = null;
			int nbline = 0;
			while((line = inputConfstream.ReadLine()) != null)
			{
				switch(nbline)
				{
					case 0:
							this.ftpInfo.setIp(line.ToString());
							break;
					case 1:
							this.ftpInfo.setPort(Convert.ToInt32(line.ToString()));
							break;
					case 2:
							this.ftpInfo.setDirectory(line.ToString());
							break;
					case 3:
							this.ftpInfo.setUser(line.ToString());
							break;
					case 4:
							this.ftpInfo.setPassword(line.ToString());
							break;
					case 5:
						{
							string result = line.ToString();
							if(result.Equals("Y"))
								this.cache = true;
							else
								this.cache = false;
							result = null;
							break;
						}
					case 6:
						{
							string result = line.ToString();
							if(result.Equals("Y"))
								this.gDrive = true;
							else
								this.gDrive = false;
							result = null;
							break;
						}
					case 7:
						{
							this.XBMC = line.ToString();
							break;
						}
					default:
							Console.WriteLine("Error in conf file, Line not handle");
							//AppendText("Error in conf file, Line not handle");
							break;
				}
				nbline++;
			}
			inputConfstream.Close();
			inputConfstream = null;
			#if ( DEBUG )
				Console.WriteLine("Readconf == user: \"" + this.ftpInfo.getUser() +
									"\" pass: \"" + this.ftpInfo.getPassword() +
									"\" IP: \"" + this.ftpInfo.getIp() +
									"\" PORT: \"" + this.ftpInfo.getPort() +
									"\" Dir: \"" + this.ftpInfo.getDirectory() + "\"" +
									"Cache: " + this.getCache() );
			#endif
			return true;
		}
		
		public bool getCache()	{ return this.cache; } 
		public bool getGDrive()	{ return this.gDrive; }
		public string getXBMC()	{ return this.XBMC; }
		public Xbgm.FTP.Configuration getFtpInfo()	{ return this.ftpInfo; }
		
		public void setFtpInfo(Xbgm.FTP.Configuration ftpInfo) { this.ftpInfo = ftpInfo; }
		
		public void set(Xbgm.Configuration cfg)
		{
			this.ftpInfo = cfg.getFtpInfo();
			this.cache = cfg.getCache(); 
			this.gDrive = cfg.getGDrive();
			this.XBMC = cfg.getXBMC();
		}

		/// <summary>
		// Returns a String representation of the value of the current instance.
		/// </summary>
		override public string ToString()
		{
			return
				this.ftpInfo.ToString() + "\n" + (this.cache?"Y":"N") + "\n" +
				(this.gDrive?"Y":"N") + "\n" + this.XBMC.ToString();
		}
		
		
		/// <summary>
		///  Set default configuration values
 		/// </summary>
		private void SetDefaultValues()
		{
			this.ftpInfo =
				new Xbgm.FTP.Configuration(
					"10.0.0.3", // IP
					21,			// Port
					"F:/",		// Directory
					"xbox",		// User
					"xbox");	// Password
			this.cache = true; 	// Use Cache
			this.gDrive = false;// Enable G Drive
			this.XBMC = "E:/XBMC/default.xbe"; // Path to XBMC
		}
	}
}
