Attribute VB_Name = "modSelectFolder"
Option Explicit
Public Type BROWSEINFO
    hOwner           As Long
    pidlRoot         As Long
    pszDisplayName   As String
    lpszTitle        As String
    ulFlags          As Long
    lpfn             As Long
    lParam           As Long
    iImage           As Long
End Type
Private Type OPENFILENAME
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    lpstrFilter As String
    lpstrCustomFilter As String
    nMaxCustomFilter As Long
    nFilterIndex As Long
    lpstrFile As String
    nMaxFile As Long
    lpstrFileTitle As String
    nMaxFileTitle As Long
    lpstrInitialDir As String
    lpstrTitle As String
    Flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    lpstrDefExt As String
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type
Public Const BIF_RETURNONLYFSDIRS = &H1
Public Const BIF_DONTGOBELOWDOMAIN = &H2
Public Const BIF_STATUSTEXT = &H4
Public Const BIF_RETURNFSANCESTORS = &H8
Public Const BIF_BROWSEFORCOMPUTER = &H1000
Public Const BIF_BROWSEFORPRINTER = &H2000
Private Const OFN_HIDEREADONLY = &H4
Private Const OFN_OVERWRITEPROMPT = &H2
Private Const OFN_PATHMUSTEXIST = &H800
Private Const OFN_LONGNAMES = &H200000
Private Const OFN_CREATEPROMPT = &H2000 ' prompt to overwrite
Private Const OFN_NODEREFERENCELINKS = &H100000
Public Const MAX_PATH = 255
Public Declare Function SHGetPathFromIDList Lib "shell32.dll" Alias "SHGetPathFromIDListA" _
                                (ByVal pidl As Long, ByVal pszPath As String) As Long
Public Declare Function SHBrowseForFolder Lib "shell32.dll" Alias "SHBrowseForFolderA" _
                                (lpBrowseInfo As BROWSEINFO) As Long
Public Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal pv As Long)
Private Declare Function GetSaveFileName Lib "comdlg32.dll" _
       Alias "GetSaveFileNameA" (lpofn As OPENFILENAME) As Long
Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias _
 "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long

Public Function SelectFolder(frm As Form, Optional sDialTitle As String = "Select a folder") As String
Dim bi As BROWSEINFO
Dim pidl As Long
Dim path As String
Dim pos As Integer
With bi
    .hOwner = frm.HWND
    .pidlRoot = 0&
    .lpszTitle = sDialTitle
    .ulFlags = BIF_RETURNONLYFSDIRS
End With
pidl = SHBrowseForFolder(bi)
path = Space$(MAX_PATH)
If SHGetPathFromIDList(ByVal pidl, ByVal path) Then
    pos = InStr(path, Chr$(0))
    SelectFolder = Left(path, pos - 1)
Else
    SelectFolder = ""
End If
Call CoTaskMemFree(pidl)
End Function

Function GetSaveName(Optional ByVal WindowTitle As String = "Save File", _
         Optional ByVal FilterStr As String = "All Files" + vbNullChar + "*.*") As String
Dim DlgInfo As OPENFILENAME
Dim RET As Long
With DlgInfo
    .lStructSize = Len(DlgInfo)
    .hwndOwner = 0
    .lpstrFilter = FilterStr
    .nFilterIndex = 1
    .lpstrFile = Space(512) & vbNullChar
    .nMaxFile = Len(.lpstrFile)
    .lpstrFileTitle = Space(256) & vbNullChar
    .nMaxFileTitle = Len(.lpstrFileTitle)
    .lpstrInitialDir = DatPath & vbNullChar
    .lpstrTitle = WindowTitle & vbNullChar
    .Flags = OFN_PATHMUSTEXIST Or OFN_HIDEREADONLY Or OFN_OVERWRITEPROMPT
    .nMaxCustomFilter = 0
    .nFileOffset = 0
    .nFileExtension = 0
    .lCustData = 0
    .lpfnHook = 0
    .hInstance = 0
End With
RET = GetSaveFileName(DlgInfo)
If Not RET = 0 Then
    GetSaveName = Left(DlgInfo.lpstrFile, InStr(DlgInfo.lpstrFile, vbNullChar) - 1)
Else
    GetSaveName = ""
End If
End Function

Function GetOpenName(Optional ByVal WindowTitle As String = "Load File", _
                     Optional ByVal Filters As String = "All Files" + vbNullChar + "*.*", _
                     Optional ByVal DefaultFileName As String = "")
Dim RET As Long
Dim DlgInfo As OPENFILENAME
With DlgInfo
    .lStructSize = Len(DlgInfo)
    .hwndOwner = 0
    .lpstrFilter = Filters
    .nFilterIndex = 1
    .lpstrFile = DefaultFileName & Space$(1024) & vbNullChar & vbNullChar
    .nMaxFile = Len(.lpstrFile)
    .lpstrDefExt = vbNullChar & vbNullChar
    .lpstrFileTitle = vbNullChar & Space$(512) & vbNullChar & vbNullChar
    .nMaxFileTitle = Len(.lpstrFileTitle)
    .lpstrInitialDir = DatPath + vbNullChar
    .lpstrTitle = WindowTitle
    .Flags = OFN_LONGNAMES Or OFN_CREATEPROMPT Or OFN_NODEREFERENCELINKS
End With
GetOpenName = GetOpenFileName(DlgInfo)
GetOpenName = Left(DlgInfo.lpstrFile, InStr(DlgInfo.lpstrFile, vbNullChar) - 1)
End Function

