/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using Gtk;


/// <summary>
/// Description of PrefDialog.	
/// </summary>
public class PrefDialog
	{
		Dialog		dialog;
		Entry 		DIR_entry;
		Entry 		PORT_entry;
	    SpinButton 	spinner;
		Entry 		IP_entry;
		Entry 		USER_entry;
		Entry 		PASS_entry;
		Entry 		XBMC_entry;
		CheckButton Cache;
		CheckButton Gdrive;
		int Response;

		public PrefDialog() 
		{ 
			CreateGui();
		}

		public void CreateGui() 
		{
			dialog = new Dialog ();
			dialog.Title = "Configuration";
			dialog.BorderWidth = 3;
			dialog.VBox.BorderWidth = 5;
			dialog.HasSeparator = false;

			Frame frame = new Frame ("Configuration");
			string image = Stock.DialogInfo;
			
			HBox hbox = new HBox (false, 2);
			hbox.BorderWidth = 5;
			hbox.PackStart (new Gtk.Image (image, IconSize.Dialog), true, true, 0);
		
			Table table = new Table (6, 3, false);
			hbox.PackStart (table);
			table.ColumnSpacing = 4;
			table.RowSpacing = 4;
			Label label = null;

			label = new Label ("IP: ");
			label.SetAlignment(1,1);
			label.Justify = Justification.Right;
			table.Attach (label, 0, 1, 0, 1);
			IP_entry = new Entry ();
			IP_entry.Text = "10.0.0.3";
			table.Attach (IP_entry, 1, 2, 0, 1);
			
			label = new Label ("Port: ");
			label.SetAlignment(2,2);
			label.Justify = Justification.Right;
			table.Attach (label, 0, 1, 1, 2);
			PORT_entry = new Entry ();
			PORT_entry.Text = "21";
			//table.Attach (PORT_entry, 1, 2, 1, 2);
		
			spinner = new SpinButton(0, 99999, 1);
 			spinner.Value = 21;
    		table.Attach (spinner, 1, 2, 1, 2);
    		
			label = new Label ("User: ");
			label.SetAlignment(3,3);
			label.Justify = Justification.Right;
			table.Attach (label, 0, 1, 2, 3);
			USER_entry = new Entry ();
			USER_entry.Text = "xbox";
			table.Attach (USER_entry, 1, 2, 2, 3);			
			
			label = new Label ("Pass: ");
			label.SetAlignment(4,4);
			label.Justify = Justification.Right;
			table.Attach (label, 0, 1, 3, 4);
			PASS_entry = new Entry ();
			PASS_entry.Text = "xbox";
			table.Attach (PASS_entry, 1, 2, 3, 4);
					
			label = new Label ("Directory: ");
			label.SetAlignment(4,4);
			table.Attach (label, 0, 1, 4, 5);
			DIR_entry = new Entry ();
			DIR_entry.Text = "F:/";
			table.Attach (DIR_entry, 1, 2, 4, 5);

			label = new Label ("XBMC: ");
			label.SetAlignment(5,5);
			table.Attach (label, 0, 1, 5, 6);
			XBMC_entry = new Entry ();
			XBMC_entry.Text = "E:/XBMC/default.xbe";
			table.Attach (XBMC_entry, 1, 2, 5, 6);

			VBox vbox = new VBox (false, 2);
			
			hbox.PackStart (vbox);
			
			Cache = new CheckButton();
			Cache.Label = "Use Cache";
			Cache.Active = true;
			vbox.PackStart (Cache);
			
			Gdrive = new CheckButton();
			Gdrive.Label = "Use G Drive";
			Gdrive.Active = false;
			vbox.PackStart (Gdrive);
			frame.Add (hbox);
			
			dialog.VBox.PackStart (frame, true, true, 0);

			Button button = null;
			button = new Button (Stock.Cancel);
			button.Clicked += new EventHandler (Dialog_Cancel);
			dialog.ActionArea.PackStart (button, true, true, 0);
			
			button = new Button (Stock.Ok);
			button.Clicked += new EventHandler (Connect_Action);
			button.CanDefault = true;
			dialog.ActionArea.PackStart (button, true, true, 0);
			button.GrabDefault ();

			dialog.Modal = true;
			dialog.ShowAll ();
			dialog.Present();
		}

		private void OutputValue(object source, System.EventArgs args)
		{	
			SpinButton spinner = source as SpinButton;
    		System.Console.WriteLine("Current value is: " + spinner.ValueAsInt);
		}
		
		void Connect_Action (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("IP:" + this.IP + " Port:" + this.Port +
								"\nUser:" +	this.User + " Passwd:" + this.Password);
			#endif
			
			Response = (int)ResponseType.Ok;
			dialog.Hide ();
		}

		void Dialog_Cancel (object o, EventArgs args) 
		{
			Response = (int)ResponseType.Cancel;
			dialog.Hide ();
		}

		public int Run ()
		{
			dialog.Run();
			return Response;
		}
	
		// To get the info PASS USER IP DIR PORT
		public string Password
		{
			get { return PASS_entry.Text; }
			set { PASS_entry.Text = value; }
		}
		
		public string User
		{
			get { return USER_entry.Text; }
			set { USER_entry.Text = value; }
		}

		public string IP
		{
			get { return IP_entry.Text; }
			set { IP_entry.Text = value; }
		}

		public string Dir
		{
			get { return DIR_entry.Text; }
			set { DIR_entry.Text = value; }
		}

		public int Port
		{
/*
 * 			get { return Convert.ToInt32(PORT_entry.Text); }
			set { PORT_entry.Text = value.ToString(); }
*/
			get { return spinner.ValueAsInt; }
			set { spinner.Value = Convert.ToInt32(value); }
		}
		
		public bool UseCache
		{
			get { return Cache.Active; }
			set { Cache.Active = value; }
		}

		public bool UseGdrive
		{
			get { return Gdrive.Active; }
			set { Gdrive.Active = value; }
		}
		
		public string XBMCDir
		{
			get { return XBMC_entry.Text; }
			set { XBMC_entry.Text = value; }
		}
		
		public void Close()
		{
			dialog.Destroy();
		}
		
		private Xbgm.Configuration cfg
		{
			get
			{
				return
					new Xbgm.Configuration(
						new Xbgm.FTP.Configuration(IP_entry.Text, spinner.ValueAsInt,
												DIR_entry.Text,
												USER_entry.Text, PASS_entry.Text),
						Cache.Active,
						Gdrive.Active,
						XBMC_entry.Text);
			}
			
			set
			{
				USER_entry.Text = value.getFtpInfo().getUser();
				PASS_entry.Text = value.getFtpInfo().getPassword();
				IP_entry.Text = value.getFtpInfo().getIp();
				spinner.Value = value.getFtpInfo().getPort();
				DIR_entry.Text = value.getFtpInfo().getDirectory();
				Cache.Active = value.getCache();
				Gdrive.Active = value.getGDrive();
				XBMC_entry.Text = value.getXBMC();
			}
		}
		
		public void setConfiguration(Xbgm.Configuration cfg)
		{
			this.cfg = cfg;
		}

		public Xbgm.Configuration getConfiguration()
		{
			return this.cfg;
		}
	}

}
