package com.superhac.JXBStreamer.Gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;


/** Example of a simple static TreeModel. It contains a
    (java.io.File) directory structure.
    (C) 2001 Christian Kaufhold (ch-kaufhold@gmx.de)
*/

public class FileTreeModel
    implements TreeModel, Serializable, Cloneable
{
	final static long serialVersionUID = 45344434L; 
    protected EventListenerList listeners;

    private static final Object LEAF = new Serializable() {
    	final static long serialVersionUID = 4543322534L; 
    };
 
    private Map map;


    private File root;


    public FileTreeModel(File root) throws NullPointerException
    {
       this.root = root;
    	
         
        if (!root.isDirectory())
        {
        	try{
            map.put(root, LEAF);
        	}
        	// we need to do this for windows removal drives...A:
        	// if the media is not there it will throw a null exception.. catch and set the table to NULL
        	catch(NullPointerException e) 
        	{
        		throw e;
        	}
        }
        this.listeners = new EventListenerList();

        this.map = new HashMap();
        	 
    }


    public Object getRoot()
    {
        return root;
    }

    public boolean isLeaf(Object node)
    {
        return map.get(node) == LEAF;
    }

    public int getChildCount(Object node)
    {
        List children = children(node);

        if (children == null)
            return 0;

        return children.size();
    }

    public Object getChild(Object parent, int index)
    {
        return children(parent).get(index);
    }

    public int getIndexOfChild(Object parent, Object child)
    {
        return children(parent).indexOf(child);
    }

    protected List children(Object node)
    {
        File f = (File)node;

        Object value = map.get(f);

        if (value == LEAF)
            return null;

        List children = (List)value;

        if (children == null)
        {
            File[] c = f.listFiles(new DirFilter());
           
            if (c != null)
            {
                children = new ArrayList(c.length);

                for (int len = c.length, i = 0; i < len; i++)
                {
                    children.add(c[i]);
                    if (!c[i].isDirectory())
                        map.put(c[i], LEAF);
                }
            }
            else
                children = new ArrayList(0);

            map.put(f, children);       
        }

        return children;
    }

    public void valueForPathChanged(TreePath path, Object value)
    {
    }

    public void addTreeModelListener(TreeModelListener l)
    {
        listeners.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l)
    {
        listeners.remove(TreeModelListener.class, l);
    }

    public Object clone()
    {
        try
        {
            FileTreeModel clone = (FileTreeModel)super.clone();
    
            clone.listeners = new EventListenerList();
    
            clone.map = new HashMap(map);
    
            return clone;
        }
        catch (CloneNotSupportedException e)
        {
            throw new InternalError();
        }
    }
    
    public static void main(String[] args)
    {
        
    	//String path = System.getProperty( "user.home" ) +
        //File.separatorChar + "Desktop"; 
        File root = new File("/");

        if (!root.exists())
        {
            System.err.println(root+ ": No such file or directory");
            System.exit(2);
        }

        JTree tree = new JTree(new FileTreeModel(root));

        JFrame f = new JFrame(root.toString());

        f.addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                System.exit(0);
            }
        });

        f.getContentPane().add(new JScrollPane(tree));

        f.pack();
        f.setVisible(true);
    }
    
}
class DirFilter implements FileFilter
{
  public boolean accept(java.io.File a)
  {
    return a.isDirectory();
  }

} 


