package com.superhac.JXBStreamer.Gui;

import java.io.OutputStream;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.superhac.JXBStreamer.Core.Debug;



public class DebugWindow {

	private JFrame jFrame = null;  //  @jve:decl-index=0:visual-constraint="244,46"
	private JPanel jContentPane = null;
	private JTextArea jTextArea = null;
	private JScrollPane jScrollPane = null;

	private Logger logger;
	private WindowHandler st = new WindowHandler();
	
	public DebugWindow()
	{
		Debug.debug = true;
		logger = Debug.getLogger();
		// this stops the console logging!
		logger.setUseParentHandlers(false);
	}
	
	/**
	 * This method initializes jFrame	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	public JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setSize(new java.awt.Dimension(613,430));
			jFrame.setTitle("Debug");
			jFrame.setMinimumSize(new java.awt.Dimension(600,400));
			jFrame.setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
			jFrame.setContentPane(getJContentPane());
			jFrame.addWindowListener(new java.awt.event.WindowAdapter() {
				public void windowClosing(java.awt.event.WindowEvent e) {
					// window closed
					Debug.debug = false;
					logger.removeHandler(st);
					jFrame.dispose();
					// unregister handle
					
				}
			});
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BoxLayout(getJContentPane(), BoxLayout.X_AXIS));
			jContentPane.add(getJScrollPane(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jTextArea	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getJTextArea() {
		if (jTextArea == null) {
			jTextArea = new JTextArea();
			jTextArea.setPreferredSize(new java.awt.Dimension(600,400));
	
			// get the jtextarea from the handler!
			jTextArea = st.getJTextArea();
			logger.addHandler(st);
			
		}
		return jTextArea;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJTextArea());
		}
		return jScrollPane;
	}

	class WindowHandler extends StreamHandler
	{
		//JTextArea output;
		 final JTextArea output = new JTextArea();
	   
		 public WindowHandler()
		 	{
	      setOutputStream(new OutputStream() {
	            public void write(int b) {} // not called
	            
	            public void write(byte[] b, int off, int len)
	            {
	               output.append(new String(b, off, len));
	            }
	         });
	      
	   }
	   
		 public JTextArea getJTextArea()
	      {
	    	  return output;
	      }
		 
		 public void publish(LogRecord record)
		   {
		      super.publish(record);
		      flush();
		   }
	}
	
}
