package com.superhac.JXBStreamer.Core;

/*
 
 * InternalIPFinder.java
 *
 * Created on April 4, 2006, 10:00 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */


import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * A static class for getting the servers own binding IP address.
 * @author sjscott
 */
public class InternalIPFinder {
    
    /**
     * Creates a new instance of InternalIPFinder
     */
    public InternalIPFinder() {
    }
    
    public static String getLocalIPAddress()
    {
        String localIP="";
        
        localIP = getSiteLocalIP();
        
        return localIP;
    }
    
    private static String getSiteLocalIP()
        
    {
        String localIP ="";
        
        try {
        Enumeration interfaces = NetworkInterface.getNetworkInterfaces();

        
        while (interfaces.hasMoreElements()) {
            NetworkInterface nif = (NetworkInterface) interfaces.nextElement();
            Enumeration addresses = nif.getInetAddresses();

            //System.out.println("Interface " + nifs++ + ": " + nif.getDisplayName());

            
            while (addresses.hasMoreElements()) {
                InetAddress addr = (InetAddress) addresses.nextElement();

                // if the SiteLocal is true this is the IP address of the host.
                if(addr.isSiteLocalAddress())
                {
                    localIP = addr.getHostAddress();
                }
               
                /* System.out.println("\tAddress " + naddrs++ + ": " +
                                   addr.getCanonicalHostName());

                System.out.println("\t\tIP: " + addr.getHostAddress());
                System.out.println("\t\tlinklocal: " +
                                   addr.isLinkLocalAddress());
                System.out.println("\t\tsitelocal: " +
                                   addr.isSiteLocalAddress());
                System.out.println("\t\tloopback:  " +
                                   addr.isLoopbackAddress());
                 */
            }
        }
        
        }
        catch (Exception e)
        {
            System.out.println("Problems getting local ip address!");
            return localIP;
        }
        
        return localIP;
    } 
    
}
