/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// www.enterprisedt.com
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using Gtk;


/// <summary>
/// Description of RenameDialog.	
/// </summary>
public class RenameDialog
	{
		Dialog dialog;
		Entry Game_entry;
		int Response;

		public RenameDialog(string xbename) 
		{ 
			dialog = new Dialog ();
			dialog.Title = "Rename";
			dialog.BorderWidth = 3;
			dialog.VBox.BorderWidth = 5;
			dialog.HasSeparator = false;

			Frame frame = new Frame ("Rename XBE");
			string image = Stock.DialogInfo;
			
			HBox hbox = new HBox (false, 2);
			hbox.BorderWidth = 5;
			hbox.PackStart (new Gtk.Image (image, IconSize.Dialog), true, true, 0);
		
			Table table = new Table (2, 3, false);
			hbox.PackStart (table);
			table.ColumnSpacing = 4;
			table.RowSpacing = 4;
			Label label = null;

			label = new Label ("Are you sure you want to rename");
			table.Attach (label, 0, 1, 0, 1);
			Game_entry = new Entry ();
			Game_entry.Text = xbename;
			table.Attach (Game_entry, 1, 2, 0, 1);
			
			frame.Add (hbox);

			dialog.VBox.PackStart (frame, true, true, 0);

			Button button = null;
			button = new Button (Stock.Ok);
			button.Clicked += new EventHandler (Connect_Action);
			button.CanDefault = true;
			dialog.ActionArea.PackStart (button, true, true, 0);
			button.GrabDefault ();

			button = new Button (Stock.Cancel);
			button.Clicked += new EventHandler (Dialog_Cancel);
			dialog.ActionArea.PackStart (button, true, true, 0);
			dialog.Modal = true;

			dialog.ShowAll ();
		}

		
		void Connect_Action (object o, EventArgs args) 
		{
			//Console.WriteLine("1:" + USER_entry.Text + " 2:" + PASS_entry.Text);
			Response = (int)ResponseType.Ok;
			dialog.Hide ();
		}

		void Dialog_Cancel (object o, EventArgs args) 
		{
			Response = (int)ResponseType.Cancel;			
			dialog.Hide ();
		}

		public int Run ()
		{
			dialog.Run();
			return Response;
		}
	
		// To get the info PASS USER IP DIR
		public string Game
		{
			get { return Game_entry.Text; }
		}
		
		public void Close()
		{
			dialog.Destroy();
		}
	}

}
