package kr.miditunemodel;

import java.io.File;
import java.io.IOException;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

import kr.util.LinkedList;
import kr.util.Util;

public abstract class Event extends LinkedList.Entry implements Comparable<Event>
{
	Event.Type type;
	long micros;
	long endMicros;

	public enum Type 
	  { LYRIC,     //lyrics
		TUNE,      //a musical note
		KR_COMM, // an event used by karaoke revolution 
		METRODOME // song timing
		};
	
	public Event(Event.Type type, long micros)
	{
		this.type = type;
		this.endMicros = this.micros = micros;
	}

	public void setMicros(long micros) {
		this.micros = micros;
	}

	public Event.Type getType() {
		return type;
	}
	
	public long getEndMicros() {
		return endMicros;
	}

	public void setEndMicros(long endMicros) {
		this.endMicros = endMicros;
	}

	public int compareTo(Event e)
	{
		if(e.getMicros() != getMicros())
		{
			long diff = getMicros() - e.getMicros();
			if(diff < 0)
				return -1;
			return 1;
		}
		if(type != e.type)
			return type.compareTo(type);
		
		return 0;
	}
	
	public long getMicros() {
		return micros;
	}

	public boolean equals(Object o)
	{
		Event eo = (Event)o;
		if(//type == eo.type && 
				micros == eo.micros)
			return true;
		return false;
	}
	
	public abstract Event clone();

	/**
	 * Changes the position of the note to the given micros value
	 */
	public void moveTo(long newMicros) {
		endMicros = endMicros - micros + newMicros;
		micros = newMicros;
	}
}

