package kr.miditunemodel;

import kr.gui.midigraph.NoteUI;
import kr.gui.midigraph.ScaleUI;
import kr.undo.Operation;

public class CreateEventOperation<T extends Event> extends MidiOperation<T> implements Operation
{

	private EventGroup<T> eventGroup;

	public CreateEventOperation(EventGroup<T> eventGroup)
	{
		this.eventGroup = eventGroup;
	}
	
	public void setNewEvent(T e)
	{
		super.event = e;
	}
	
	public void undo() 
	{
		eventGroup.removeEvent(super.event);
	}

	public void doIt() 
	{
		eventGroup.insertEvent(super.event);
	}

	public boolean isValid() {
		return true;
		
	}

	
}
