package kr.miditunemodel;

import kr.gui.midigraph.NoteUI;
import kr.gui.midigraph.ScaleUI;
import kr.undo.Operation;

public class ChangeNoteOperation extends ChangeEventOperation<NoteEvent> implements Operation
{
	private int noteDelta;

	public ChangeNoteOperation(NoteEvent ne)
	{
		super(ne);
	}
	
	public void setNewNote(byte newNote)
	{
		this.noteDelta = newNote - event.getNote();
	}

	public void undo() 
	{
		super.undo();
		((NoteEvent) event).setNote((byte)(((NoteEvent) event).getNote() - noteDelta));
	}

	public void doIt() 
	{
		super.doIt();
		((NoteEvent) event).setNote((byte)(((NoteEvent) event).getNote() + noteDelta));
	}

	public boolean isValid() {
		if(!super.isValid() || event.getNote() + noteDelta > MidiTuneModel.MAX_NOTE || event.getNote() + noteDelta < MidiTuneModel.MIN_NOTE
				|| event.getMicros() < 0)
			return false;
		return true;
		
	}

	
}
