package kr.gui.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.text.PlainDocument;
import javax.swing.text.Document;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

/**
 * Applys the pattern against the string with a replaceAll each time a character is pressed
 */
public class RegexpRestrictor extends InsertRestrictor 
{
	private Pattern regexp;
	private String replacement;

	public RegexpRestrictor(String regexp, String replacement)
	{
		this.regexp = Pattern.compile(regexp);
		this.replacement = replacement;
	}
	
	public String insertStringImpl(Document d, int offs, 
								 String str,
								 AttributeSet a) 
	{
		if(str != null)
		{
			str = regexp.matcher(str).replaceAll(replacement);
		}

		return str;
	}
}

