package kr.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;

import kr.gui.util.MilliTimeLabelTable;

public class MiscSettingsPanel extends JPanel {

	private Model model;
	private MiscSettingsController miscSettingsController;
	JCheckBox createBackgroundFromVocals;
	JButton updateButton;

	public MiscSettingsPanel(Model model, MiscSettingsController miscSettingsController) {
		this.model = model;
		this.miscSettingsController = miscSettingsController;
		init();
		miscSettingsController.init(model,this);
	}

	private void init() {
        setLayout(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();
		c.fill = c.BOTH;
		c.weighty = 0; c.weightx = 0;
		c.gridx = c.gridy = 0;
        
		add(createBackgroundFromVocals = new JCheckBox("Create background from vocals (L-R method)"), c);
        
		c.gridx = 1;
		add(updateButton = new JButton("Update"), c);
	}

}
